import React from 'react';
import { DotDialog, DotSkeleton } from '@digital-ai/dot-components';
import { mountWithTheme, ReactWrapper } from '../../../../../../../../../../core/xlr-ui/tests/unit/testing-utils';
import { ActivityLogsEventDialog } from './activity-logs-event-dialog.component';

describe('ActivityLogsEventDialog', () => {
    let wrapper: ReactWrapper;
    const onClose = jest.fn();

    const mount = (content?: string) => {
        wrapper = mountWithTheme(<ActivityLogsEventDialog content={content} onClose={onClose} />);
    };

    const getDialog = () => wrapper.find(DotDialog);
    const getContent = () => wrapper.find('pre').text();
    const getSkeletons = () => wrapper.find(DotSkeleton);

    it('should render dialog with content', () => {
        mount('my content');
        const dialogProps = getDialog().props();
        expect(dialogProps.cancelButtonVisible).toBe(false);
        expect(dialogProps.className).toBe('activity-logs-event-dialog');
        expect(dialogProps.closeIconVisible).toBe(true);
        expect(dialogProps.onCancel).toBe(onClose);
        expect(dialogProps.onSubmit).toBe(onClose);
        expect(dialogProps.open).toBe(true);
        expect(dialogProps.submitButtonProps).toStrictEqual({
            label: 'Close',
        });
        expect(dialogProps.title).toBe('Event details');

        expect(getContent()).toBe('my content');
    });

    it('should render dialog with skeletons when no content', () => {
        mount();
        expect(getSkeletons()).toExist();
    });
});
