package com.xebialabs.xlrelease.activity;

import java.util.Date;
import java.util.List;

import com.xebialabs.xlrelease.domain.ActivityLogEntry;
import com.xebialabs.xlrelease.domain.Phase;

import static com.google.common.base.Objects.equal;
import static com.google.common.collect.Lists.newArrayList;
import static com.google.common.primitives.Ints.checkedCast;
import static com.xebialabs.xlrelease.activity.DurationFormatter.formatDuration;
import static com.xebialabs.xlrelease.activity.ReleaseActivityDateFormatter.formatDate;
import static com.xebialabs.xlrelease.domain.ReleaseActivity.PHASE_COLOR_CHANGED;
import static com.xebialabs.xlrelease.domain.ReleaseActivity.PHASE_DESCRIPTION_UPDATED;
import static com.xebialabs.xlrelease.domain.ReleaseActivity.PHASE_DUE_DATE_UPDATED;
import static com.xebialabs.xlrelease.domain.ReleaseActivity.PHASE_DURATION_UPDATED;
import static com.xebialabs.xlrelease.domain.ReleaseActivity.PHASE_RENAMED;
import static com.xebialabs.xlrelease.domain.ReleaseActivity.PHASE_SCHEDULED_START_DATE_UPDATED;

public class PhaseFieldsComparator {
    private Date timestamp;
    private String username;
    private Phase original;
    private Phase updated;

    public PhaseFieldsComparator(Date timestamp, String username, Phase original, Phase updated) {
        this.timestamp = timestamp;
        this.username = username;
        this.original = original;
        this.updated = updated;
    }

    public List<ActivityLogEntry> getLogs() {
        List<ActivityLogEntry> logEntries = newArrayList();

        if (!equal(original.getTitle(), updated.getTitle())) {
            logEntries.add(PHASE_RENAMED.create(timestamp, username, original.getType(), original.getId(), original.getTitle(), updated.getTitle()));
        }

        if (!equal(original.getDescription(), updated.getDescription())) {
            logEntries.add(PHASE_DESCRIPTION_UPDATED.create(timestamp, username, original.getType(), original.getId(),
                    updated.getTitle(), original.getDescription(), updated.getDescription()
            ));
        }

        if (!equal(original.getDueDate(), updated.getDueDate())) {
            logEntries.add(PHASE_DUE_DATE_UPDATED.create(timestamp, username, original.getType(), original.getId(),
                    updated.getTitle(), formatDate(original.getDueDate()), formatDate(updated.getDueDate())
            ));
        }

        if (!equal(original.getScheduledStartDate(), updated.getScheduledStartDate())) {
            logEntries.add(PHASE_SCHEDULED_START_DATE_UPDATED.create(timestamp, username, original.getType(), original.getId(),
                    updated.getTitle(), formatDate(original.getScheduledStartDate()), formatDate(updated.getScheduledStartDate())
            ));
        }

        if (!equal(original.getColor(), updated.getColor())) {
            logEntries.add(PHASE_COLOR_CHANGED.create(timestamp, username, original.getType(), original.getId(),
                    updated.getTitle(), original.getColor(), updated.getColor()
            ));
        }

        Integer newDuration = null;
        if (updated.getPlannedDuration() != null) {
            newDuration = checkedCast(updated.getPlannedDuration() / 1000L);
        }
        if (!equal(original.getPlannedDuration(), newDuration)) {
            logEntries.add(PHASE_DURATION_UPDATED.create(timestamp, username, original.getType(), original.getId(),
                    updated.getTitle(), formatDuration(original.getPlannedDuration()), formatDuration(newDuration)
            ));
        }

        return logEntries;
    }
}
