import React from 'react';
import { DotLink, DotTypography, DotTooltip } from '@digital-ai/dot-components';
import { mountWithTheme, ReactWrapper } from '../../../../../../../../../../core/xlr-ui/tests/unit/testing-utils';
import { ActivityLogsTypeDelivery, ActivityLogsTypeDeliveryProps } from './activity-logs-type.delivery.component';

describe('ActivityLogsTypeDelivery component', () => {
    let wrapper: ReactWrapper;

    const getTypeLabelTypography = () => wrapper.findWhere((node) => node.is(DotTypography) && node.props()['data-testid'] === 'type-label-typography');
    const getDotLink = () => wrapper.find(DotLink);
    const getTooltip = () => wrapper.find(DotTooltip);
    const mount = (props: ActivityLogsTypeDeliveryProps) => {
        wrapper = mountWithTheme(<ActivityLogsTypeDelivery {...props} />);
    };

    afterAll(() => {
        jest.restoreAllMocks();
    });

    it('should render "not available" message if there is no targetId', () => {
        mount({ targetId: null, targetType: null });
        expect(getDotLink()).not.toExist();
        expect(getTypeLabelTypography()).toIncludeText('Not available');
        expect(getTooltip().props().title).toBe(
            'Link is unavailable because the target item cannot be identified or referenced for deliveries older than version 9.0.0.',
        );
    });

    it('should render links for delivery events', () => {
        window.location.hash = '#/deliveries/Deliveries/Delivery1/logs';
        mount({ targetId: 'Deliveries/Delivery1', targetType: 'delivery.Delivery' });
        expect(getTypeLabelTypography()).not.toExist();
        const dotLink = getDotLink();
        expect(dotLink).toExist();
        expect(dotLink.text()).toBe('Delivery');
        expect(dotLink.props().href).toBe('#/deliveries/Deliveries/Delivery1');
    });

    it('should render links for delivery patterns events', () => {
        window.location.hash = '#/folders/Applications/Folder1/delivery-patterns/Deliveries/Delivery1/logs';
        mount({ targetId: 'Deliveries/Delivery1', targetType: 'delivery.Delivery' });
        expect(getTypeLabelTypography()).not.toExist();
        const dotLink = getDotLink();
        expect(dotLink).toExist();
        expect(dotLink.text()).toBe('Delivery');
        expect(dotLink.props().href).toBe('#/folders/Applications/Folder1/delivery-patterns/Deliveries/Delivery1');
    });

    it('should render typography for other events', () => {
        mount({ targetId: 'Deliveries/Delivery1', targetType: 'delivery.Stage' });
        expect(getDotLink()).not.toExist();
        const typeLabelTypography = getTypeLabelTypography();
        expect(typeLabelTypography.text()).toBe('Stage');
        expect(typeLabelTypography.props().variant).toBe('body1');
    });
});
