import { ActivityLogsFilterSettings } from '../types';
import { WithTitleAndId } from '../../../../../../../../../core/xlr-ui/app/types';

export const SYSTEM_USER = 'SYSTEM';
export const LOG_USER = 'TASK COMMENT';
export const RELEASE_LOGO_SVG = 'static/@project.version@/styles/img/release-icon.svg';

export const RELEASE_ACTIVITY_LOG_FILTERS: WithTitleAndId[] = [
    { id: 'lifecycle', title: 'Release life cycle' },
    { id: 'releaseEdit', title: 'Release edits' },
    { id: 'taskEdit', title: 'Task edits' },
    { id: 'reassign', title: 'Task assignment' },
    { id: 'reportingRecordEdit', title: 'Record edits' },
    { id: 'comments', title: 'Comments' },
    { id: 'security', title: 'Security' },
    { id: 'other', title: 'Other' },
];

export const DELIVERY_ACTIVITY_LOG_CATEGORIES: WithTitleAndId[] = [
    { id: 'lifecycle', title: 'Delivery life cycle' },
    { id: 'deliveryEdit', title: 'Delivery edits' },
    { id: 'other', title: 'Other' },
];

export const TRIGGER_ACTIVITY_LOG_CATEGORIES: WithTitleAndId[] = [
    { id: 'lifecycle', title: 'Trigger life cycle' },
    { id: 'execution', title: 'Trigger execution' },
    { id: 'triggerEdit', title: 'Trigger edits' },
];

export const LOGS_ITEMS_PER_PAGE = 30;

export const DEFAULT_FILTER_SETTINGS: ActivityLogsFilterSettings = {
    activityTypes: [],
    comments: false,
    dateAsc: false,
    deliveryEdit: false,
    execution: false,
    filter: '',
    folderId: null,
    from: null,
    isImportantHighlighted: true,
    lifecycle: false,
    other: false,
    reassign: false,
    releaseEdit: false,
    reportingRecordEdit: false,
    security: false,
    taskEdit: false,
    to: null,
    triggerEdit: false,
    usernames: [],
};

export const IMPORTANT_ACTIVITY_TYPES = [
    'DELIVERY_COMPLETED',
    'ITEM_COMPLETED',
    'ITEM_COMPLETED_MANUALLY',
    'ITEM_DESCOPED',
    'ITEM_REMOVED',
    'ITEM_RESCOPED',
    'ITEM_RESET',
    'ITEM_RESET_MANUALLY',
    'ITEM_SKIPPED',
    'ITEM_TRANSITION_APPROVED',
    'PHASE_STARTED',
    'RELEASE_ABORTED',
    'RELEASE_COMPLETED',
    'RELEASE_FLAG_COMMENT_UPDATED',
    'RELEASE_FLAG_STATUS_UPDATED',
    'RELEASE_STARTED',
    'STAGE_COMPLETED',
    'STAGE_REMOVED',
    'STAGE_STARTED',
    'TASK_ABORT_SCRIPT_COMPLETED',
    'TASK_ABORT_SCRIPT_STARTED',
    'TASK_DELETED',
    'TASK_FAILED',
    'TASK_FLAG_COMMENT_UPDATED',
    'TASK_FLAG_STATUS_UPDATED',
    'TASK_RECOVERED',
    'TASK_RECOVERY_STARTED',
    'TASK_SKIPPED',
    'TASK_SKIPPED_IN_ADVANCE',
    'TRANSITION_EXECUTED_AUTOMATICALLY',
    'TRANSITION_EXECUTED_MANUALLY',
    'WORKFLOW_EXECUTION_ABORTED',
    'WORKFLOW_EXECUTION_COMPLETED',
    'WORKFLOW_EXECUTION_STARTED',
];
