import React from 'react';
import { mockResizeObserver, mountWithTheme, ReactWrapper } from '../../../../../../../../../../core/xlr-ui/tests/unit/testing-utils';
import { ActivityLogsUser, ActivityLogsUserProps } from './activity-logs-user.component';
import { AvatarWithName } from '../../../../../../../../../../core/xlr-ui/app/features/tasks/components/common/avatar-with-name.component';
import { User } from '../../../../../../../../../../core/xlr-ui/app/types';

describe('ActivityLogsUser component', () => {
    let wrapper: ReactWrapper;
    const user: User = {
        username: 'admin',
        fullName: 'Test Admin',
    };

    const defaultProps: ActivityLogsUserProps = {
        user,
    };

    const getAvatarWithName = () => wrapper.find(AvatarWithName);

    const mount = (props: ActivityLogsUserProps = defaultProps) => {
        wrapper = mountWithTheme(<ActivityLogsUser {...props} />);
    };

    beforeEach(() => {
        mockResizeObserver();
    });

    it('should render properly', () => {
        mount();
        const avatarWithName = getAvatarWithName();
        expect(avatarWithName).toExist();
        const avatarWithNameProps = avatarWithName.props();
        expect(avatarWithNameProps.avatarImgSrc).toBe(undefined);
        expect(avatarWithNameProps.id).toBe(user.username);
        expect(avatarWithNameProps.title).toBe(user.fullName);
    });

    it('should render username when full name is not available', () => {
        mount({ ...defaultProps, user: { username: 'vijay', fullName: '' } });
        expect(getAvatarWithName().props().title).toBe('vijay');
    });

    it('should render with correct props for system user', () => {
        mount({ ...defaultProps, user: { ...user, username: 'TASK COMMENT' } });
        const avatarWithName = getAvatarWithName();
        expect(avatarWithName).toExist();
        const avatarWithNameProps = avatarWithName.props();
        expect(avatarWithNameProps.avatarImgSrc).toBe('static/@project.version@/styles/img/release-icon.svg');
        expect(avatarWithNameProps.id).toBe(`TASK COMMENT`);
        expect(avatarWithNameProps.title).toBe('SYSTEM');
    });
});
