import React from 'react';
import { DotLink } from '@digital-ai/dot-components';

export interface ActivityLogsDetailsProps {
    dataId: string | null;
    onDetailsClick: (dataId: string) => void;
}

export const ActivityLogsDetails = ({ dataId, onDetailsClick }: ActivityLogsDetailsProps) => {
    if (!dataId) return null;
    return <DotLink onClick={() => onDetailsClick(dataId)}>Show details</DotLink>;
};
