import React from 'react';
import { DotLink } from '@digital-ai/dot-components';
import { mountWithTheme, ReactWrapper } from '../../../../../../../../../../core/xlr-ui/tests/unit/testing-utils';
import { ActivityLogsDetails } from './activity-logs-details.component';

describe('ActivityLogsDetails', () => {
    let wrapper: ReactWrapper;

    const onDetailsClick = jest.fn();
    const getLink = () => wrapper.find(DotLink);

    const mount = (dataId: string | null) => {
        wrapper = mountWithTheme(<ActivityLogsDetails dataId={dataId} onDetailsClick={onDetailsClick} />);
    };

    it('should not render if there is no dataId', () => {
        mount(null);
        expect(wrapper).toBeEmptyRender();
    });
    it('should render link if there is dataId', () => {
        mount('my data id');
        const link = getLink();
        link.invoke('onClick')();
        expect(onDetailsClick).toHaveBeenCalledWith('my data id');
    });
});
