package com.xebialabs.xlrelease.activity

import com.xebialabs.deployit.plugin.api.reflect.Type
import com.xebialabs.xlrelease.domain.events._
import com.xebialabs.xlrelease.domain.{Release, Team}
import com.xebialabs.xlrelease.events.{EventListener, Subscribe, XLReleaseEventBus}
import com.xebialabs.xlrelease.repository.ActivityLogRepository
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Component

import scala.jdk.CollectionConverters._

@Component
@EventListener
class PermissionsLoggingEventHandler @Autowired()(val eventBus: XLReleaseEventBus, val activityLogRepository: ActivityLogRepository)
extends ActivityLogger[PermissionsEvent] {

  @Subscribe
  def onEvent(event: PermissionsEvent): Unit = log(event)

  override def logEntries: PartialFunction[XLReleaseEvent, LoggingParams] = {
    case ev@PermissionsUpdatedEvent(teams) if teams.asScala.nonEmpty =>
      val team: Team = teams.asScala.head
      val releaseId: Option[String] = releaseIdFrom(team.getId)
      LoggingParams(releaseId, None,
        new PermissionsLogFormatter(ev.timestamp, ev.username, Type.valueOf(classOf[Release]), releaseId.getOrElse("<unknown>"), teams).getLogEntry
        // FIXME: don't pass "<unknown>" as targetId!!
      )
  }

}
