import React from 'react';
import { DotTypography } from '@digital-ai/dot-components';
import moment from 'moment';
import { act, mountWithTheme, ReactWrapper } from '../../../../../../../../../../core/xlr-ui/tests/unit/testing-utils';
import { ActivityLogsTime, ActivityLogsTimeProps } from './activity-logs-time.component';

describe('ActivityLogsTime component', () => {
    let wrapper: ReactWrapper;
    const eventTime = 1727342991712;
    const dateFormat = 'MM/dd/yyyy';
    const timeFormat = 'HH:mm:ss';

    const defaultProps: ActivityLogsTimeProps = {
        eventTime,
        dateFormat,
        timeFormat,
    };

    const getDotTypographyDate = () => wrapper.find(DotTypography).at(0);
    const getDotTypographyTime = () => wrapper.find(DotTypography).at(1);

    const mount = async (props: ActivityLogsTimeProps = defaultProps) => {
        await act(async () => {
            wrapper = mountWithTheme(<ActivityLogsTime {...props} />);
        });
    };

    it('should render properly', async () => {
        await mount();

        const dotTypographyDate = getDotTypographyDate();
        expect(dotTypographyDate).toExist();
        const dotTypographyDateProps = dotTypographyDate.props();
        expect(dotTypographyDateProps.variant).toBe('body1');
        expect(dotTypographyDateProps.children).toBe(moment(eventTime).format(dateFormat));

        const dotTypographyTime = getDotTypographyTime();
        expect(dotTypographyTime).toExist();
        const dotTypographyTimeProps = dotTypographyTime.props();
        expect(dotTypographyTimeProps.variant).toBe('body2');
        expect(dotTypographyTimeProps.children).toBe(moment(eventTime).format(timeFormat));
    });
});
