import React from 'react';
import { DotChip, DotTypography } from '@digital-ai/dot-components';
import { mountWithTheme, ReactWrapper } from '../../../../../../../../../../core/xlr-ui/tests/unit/testing-utils';
import { FilterGroupChips, FilterGroupChipsProps } from './filter-group-chips.component';

describe('FilterGroupChips', () => {
    const onDelete = jest.fn();
    let wrapper: ReactWrapper;
    const defaultProps: FilterGroupChipsProps = {
        onDelete,
        title: 'my filter title',
        values: [
            { id: '1', title: 'value 1' },
            { id: '2', title: 'value 2' },
        ],
    };

    const mount = (props: FilterGroupChipsProps = defaultProps) => {
        wrapper = mountWithTheme(<FilterGroupChips {...props} />);
    };

    const getTitle = () => wrapper.find(DotTypography);
    const getChips = () => wrapper.find(DotChip);

    it('should render the title and the values with chips', () => {
        mount();
        expect(getTitle()).toHaveText('my filter title');
        const chips = getChips();
        expect(chips).toHaveLength(2);
        expect(chips.at(0)).toHaveText('value 1');
        expect(chips.at(1)).toHaveText('value 2');
    });

    it('should render custom children if provided', () => {
        wrapper = mountWithTheme(<FilterGroupChips {...defaultProps}>{(value) => <h1 key={value.id}>{value.title}</h1>}</FilterGroupChips>);
        const h1s = wrapper.find('h1');
        expect(h1s).toHaveLength(2);
        expect(h1s.at(0)).toHaveText('value 1');
        expect(h1s.at(1)).toHaveText('value 2');
    });

    it('should handle onDelete callback', () => {
        mount();
        const chips = getChips();
        chips.at(0).invoke('onDelete')?.();
        expect(onDelete).toHaveBeenCalledWith('1');
    });
});
