import React from 'react';
import { DotChip, DotTypography } from '@digital-ai/dot-components';
import { WithTitleAndId } from '../../../../../../../../../../core/xlr-ui/app/types';
import './filter-group-chips.component.less';

export interface FilterGroupChipsProps {
    children?: (value: WithTitleAndId) => React.ReactNode;
    onDelete?: (id: string) => void;
    title: string;
    values: WithTitleAndId[];
}

export const FilterGroupChips = ({ children, onDelete, title, values }: FilterGroupChipsProps) => {
    const defaultRender = (value: WithTitleAndId) => (
        <DotChip key={value.id} onDelete={onDelete ? () => onDelete(value.id) : undefined} size="small">
            {value.title}
        </DotChip>
    );
    const renderFn = children ?? defaultRender;
    return (
        <div className="filter-group-chips">
            <DotTypography variant="subtitle2">{title}</DotTypography>
            <div className="chips">{values.map(renderFn)}</div>
        </div>
    );
};
