import React from 'react';
import { DotAvatar, DotChip } from '@digital-ai/dot-components';
import { SYSTEM_USER } from '../../constants';
import { WithTitleAndId } from '../../../../../../../../../../core/xlr-ui/app/types';
import { getSystemUserAvatar } from '../../helper';

export interface UserChipProps {
    onDelete: (id: string) => void;
    value: WithTitleAndId;
}

export const UserChip = ({ value, onDelete }: UserChipProps) => {
    const { id, title } = value;
    return (
        <DotChip
            avatar={
                <DotAvatar
                    alt={`Image for user ${title}`}
                    imageSrc={getSystemUserAvatar(id)}
                    size="small"
                    text={title}
                    type={id === SYSTEM_USER ? 'image' : 'text'}
                />
            }
            key={id}
            onDelete={() => onDelete(id)}
            size="small"
        >
            {title}
        </DotChip>
    );
};
