import React from 'react';
import { IdAutoCompleteOption } from '../../../../../../../../../../core/xlr-ui/app/features/tasks/types';
import { DotAutoComplete } from '@digital-ai/dot-components';

export interface FilterAutocompleteProps {
    className?: string;
    inputId: string;
    onChange: (ids: string[]) => void;
    options: IdAutoCompleteOption[];
    placeholder: string;
    value: IdAutoCompleteOption[];
}

export const FilterAutocomplete = ({ className, inputId, onChange, options, placeholder, value }: FilterAutocompleteProps) => {
    return (
        <DotAutoComplete
            className={className}
            freesolo={false}
            inputId={inputId}
            isOptionEqualToValue={(option: IdAutoCompleteOption, v: IdAutoCompleteOption) => option.id === v.id}
            multiple={true}
            onChange={(_ev, newValue) => {
                const selectedIds = (newValue as IdAutoCompleteOption[]).map((v) => v.id);
                onChange(selectedIds);
            }}
            options={options}
            placeholder={placeholder}
            value={value}
        />
    );
};
