import { ClientSettings, User } from '../../../../../../../../../core/xlr-ui/app/types';

export enum ActivityLogsContainerEnum {
    DELIVERY,
    RELEASE,
    TRIGGER,
}

export interface ActivityLog {
    activityType: string;
    dataId: string | null;
    eventTime: number;
    message: string;
    targetId: string;
    targetType: string;
    user: User;
}

export interface ActivityLogsFilterSettings {
    activityTypes: string[];
    comments: boolean;
    dateAsc: boolean;
    deliveryEdit: boolean;
    execution: boolean;
    filter: string;
    folderId: string | null;
    from: number | null;
    isImportantHighlighted: boolean;
    lifecycle: boolean;
    other: boolean;
    reassign: boolean;
    releaseEdit: boolean;
    reportingRecordEdit: boolean;
    security: boolean;
    taskEdit: boolean;
    to: number | null;
    triggerEdit: boolean;
    usernames: string[];
}

export interface ActivityLogColumnProps {
    background: string;
    border: string;
    label: string;
    message: string;
}

export interface ActivityLogsClientSettings extends ClientSettings {
    setLogsFilters: (containerId: string, filter: ActivityLogsFilterSettings) => void;
}
