package com.xebialabs.xlrelease.domain;

import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import com.google.common.collect.ImmutableMap;

import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem;
import com.xebialabs.xlrelease.activity.ActivityOps;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;

import static com.google.common.collect.Sets.newLinkedHashSet;
import static com.xebialabs.xlrelease.domain.ActivityCategory.COMMENTS;
import static com.xebialabs.xlrelease.domain.ActivityCategory.IMPORTANT;
import static com.xebialabs.xlrelease.domain.ActivityCategory.LIFECYCLE;
import static com.xebialabs.xlrelease.domain.ActivityCategory.REASSIGN;
import static com.xebialabs.xlrelease.domain.ActivityCategory.RELEASE_EDIT;
import static com.xebialabs.xlrelease.domain.ActivityCategory.REPORTING_RECORD_EDIT;
import static com.xebialabs.xlrelease.domain.ActivityCategory.SECURITY;
import static com.xebialabs.xlrelease.domain.ActivityCategory.TASK_EDIT;

public enum ReleaseActivity implements ActivityOps {

    TEMPLATE_CREATED("Created template", LIFECYCLE),
    TEMPLATE_CREATED_FROM_AS_CODE("Created template from As-code %s", LIFECYCLE),
    TEMPLATE_UPDATED_FROM_AS_CODE("Updated template from As-code %s", RELEASE_EDIT),
    TEMPLATE_DUPLICATED("Duplicated template to '%s'", RELEASE_EDIT),
    TEMPLATE_MOVED("Template moved from folder %s to folder %s", RELEASE_EDIT),
    TEMPLATE_CATEGORY_UPDATED("Updated categories to:\n%s", RELEASE_EDIT),
    TEMPLATE_AUTHOR_UPDATED("Changed author from '%s' to '%s'", RELEASE_EDIT),

    RELEASE_TITLE_UPDATED("Changed title from '%s' to '%s'", RELEASE_EDIT),
    RELEASE_DESCRIPTION_UPDATED("Changed description from '%s' to '%s'", RELEASE_EDIT),
    RELEASE_DUE_DATE_UPDATED("Changed due date from '%s' to '%s'", RELEASE_EDIT),
    RELEASE_SCHEDULED_START_DATE_UPDATED("Changed scheduled start date from '%s' to '%s'", RELEASE_EDIT),
    RELEASE_OWNER_UPDATED("Changed owner from %s to %s", REASSIGN, RELEASE_EDIT),
    RELEASE_TAGS_UPDATED("Updated tags to:\n%s", RELEASE_EDIT),
    RELEASE_FLAG_STATUS_UPDATED("Changed flag status from '%s' to '%s'", RELEASE_EDIT, IMPORTANT),
    RELEASE_FLAG_COMMENT_UPDATED("Changed flag comment from '%s' to '%s'", RELEASE_EDIT, IMPORTANT, COMMENTS),
    RELEASE_ABORT_RELEASE_ON_FAILURE_UPDATED("Changed 'Abort release on failure' from '%s' to '%s'", RELEASE_EDIT),
    WORKFLOW_ABORT_WORKFLOW_ON_FAILURE_UPDATED("Changed 'Abort Workflow execution on failure' from '%s' to '%s'", RELEASE_EDIT),
    RELEASE_ALLOW_PASSWORDS_IN_ALL_FIELDS_ON_FAILURE_UPDATED("Changed 'Allow passwords in all fields' from '%s' to '%s'", RELEASE_EDIT),
    RELEASE_DISABLE_NOTIFICATIONS_UPDATED("Changed 'Disable notifications' from '%s' to '%s'", RELEASE_EDIT),

    COMMENT_ADDED("Added a comment '%s' on task '%s'", TASK_EDIT, COMMENTS),
    COMMENT_UPDATED("Updated comment '%s' to '%s' on task '%s'", TASK_EDIT, COMMENTS),
    COMMENT_DELETED("Deleted comment '%s' for task '%s'", TASK_EDIT, COMMENTS),

    PHASE_CREATED("Created Phase '%s'", RELEASE_EDIT),
    PHASE_RENAMED("Renamed Phase '%s' to '%s'", RELEASE_EDIT),
    PHASE_DESCRIPTION_UPDATED("Changed description of Phase '%s' from '%s' to '%s'", RELEASE_EDIT),
    PHASE_DURATION_UPDATED("Changed duration of Phase '%s' from '%s' to '%s'", RELEASE_EDIT),
    PHASE_DUE_DATE_UPDATED("Changed due date of Phase '%s' from '%s' to '%s'", RELEASE_EDIT),
    PHASE_SCHEDULED_START_DATE_UPDATED("Changed scheduled start date of Phase '%s' from '%s' to '%s'", RELEASE_EDIT),
    PHASE_COLOR_CHANGED("Changed color of Phase '%s' from '%s' to '%s'", RELEASE_EDIT),
    PHASE_MOVED("Moved Phase '%s'", RELEASE_EDIT),
    PHASE_DELETED("Deleted Phase '%s'", RELEASE_EDIT),
    PHASE_DUPLICATED("Duplicated Phase to '%s'", RELEASE_EDIT),
    PHASE_STARTED("Started Phase '%s'", LIFECYCLE, IMPORTANT),
    PHASE_FAILED("Failed Phase '%s'", LIFECYCLE),
    PHASE_FAILING("Phase '%s' started failing", LIFECYCLE),
    PHASE_RESTARTED("Restarted Phase '%s'", LIFECYCLE),
    PHASE_COMPLETED("Completed Phase '%s'", LIFECYCLE),
    PHASE_CLOSED("Closed Phase '%s' and skipped all its tasks", LIFECYCLE),

    TASK_CREATED("Created Task '%s' of type '%s'", RELEASE_EDIT, TASK_EDIT),
    TASK_MOVED_BETWEEN_CONTAINERS("Moved Task '%s' from '%s' to '%s'", RELEASE_EDIT),
    TASK_MOVED_WITHIN_CONTAINER("Moved Task '%s' within '%s'", RELEASE_EDIT),
    TASK_DELETED("Deleted Task '%s'", RELEASE_EDIT, IMPORTANT),
    TASK_TITLE_UPDATED("Changed title of Task '%s' from '%s' to '%s'", TASK_EDIT),
    TASK_DESCRIPTION_UPDATED("Changed description of Task '%s' from '%s' to '%s'", TASK_EDIT),
    TASK_DURATION_UPDATED("Changed duration of Task '%s' from '%s' to '%s'", TASK_EDIT),
    TASK_OWNER_UPDATED("Changed owner of Task '%s' from %s to %s", TASK_EDIT, REASSIGN),
    TASK_TASK_TEAM_UPDATED("Changed team of Task '%s' from %s to %s", TASK_EDIT, REASSIGN),
    TASK_DUE_DATE_UPDATED("Changed due date of Task '%s' from '%s' to '%s'", TASK_EDIT),
    TASK_SCHEDULED_START_DATE_UPDATED("Changed scheduled start date of Task '%s' from '%s' to '%s'", TASK_EDIT),
    TASK_WAIT_FOR_SCHEDULED_START_DATE_UPDATED("Changed wait for scheduled start date of Task '%s' to '%s'", TASK_EDIT),
    TASK_FLAG_STATUS_UPDATED("Flagged Task '%s' from '%s' to '%s'", TASK_EDIT, IMPORTANT),
    TASK_FLAG_COMMENT_UPDATED("Changed flag status of Task '%s' from '%s' to '%s'", TASK_EDIT, IMPORTANT, COMMENTS),
    TASK_COPIED("Copied Task to '%s'", RELEASE_EDIT),
    TASK_INPUT_VARIABLES_UPDATED("Changed variable list of Task '%s' from '%s' to '%s'", TASK_EDIT),
    TASK_NOTIFICATION_ADDRESSES_UPDATED("Changed Notification addresses of recipients of the Task '%s' from '%s' to '%s'", TASK_EDIT),
    TASK_NOTIFICATION_CC_UPDATED("Changed Notification list of email addresses that receive the message as CC of Task '%s' from '%s' to '%s'", TASK_EDIT),
    TASK_NOTIFICATION_BCC_UPDATED("Changed Notification list of email addresses that receive the message as BCC of Task '%s' from '%s' to '%s'", TASK_EDIT),
    TASK_NOTIFICATION_REPLY_TO_UPDATED("Changed Notification email address of the reply message recipient of Task '%s' from '%s' to '%s'", TASK_EDIT),
    TASK_NOTIFICATION_FROM_UPDATED("Changed Notification email address of the message sender of Task '%s' from '%s' to '%s'", TASK_EDIT),
    TASK_NOTIFICATION_SENDER_USERNAME_UPDATED("Changed Notification email username of the message sender of Task '%s' from '%s' to '%s'", TASK_EDIT),
    TASK_NOTIFICATION_SENDER_PASSWORD_UPDATED("Changed Notification email password of the message sender of Task '%s'", TASK_EDIT),
    TASK_NOTIFICATION_PRIORITY_UPDATED("Changed Notification email priority of Task '%s' from '%s' to '%s'", TASK_EDIT),
    TASK_NOTIFICATION_SUBJECT_UPDATED("Changed Notification subject of Task '%s' from '%s' to '%s'", TASK_EDIT),
    TASK_NOTIFICATION_BODY_UPDATED("Changed Notification body of Task '%s' from '%s' to '%s'", TASK_EDIT),
    TASK_SCRIPT_UPDATED("Changed Script of Task '%s' from '%s' to '%s'", TASK_EDIT),
    TASK_INPUT_PROPERTY_UPDATED("Changed input property '%s' of Task '%s' from '%s' to '%s'", TASK_EDIT),
    TASK_INPUT_PROPERTY_PASSWORD_UPDATED("Changed input property '%s' of Task '%s'", TASK_EDIT),
    TASK_OUTPUT_PROPERTIES_UPDATED("Changed output property '%s' of Task '%s' from '%s' to '%s'", TASK_EDIT),
    TASK_PRECONDITION_UPDATED("Changed precondition of Task '%s' from '%s' to '%s'", TASK_EDIT),
    TASK_TYPE_CHANGED("Changed type of Task '%s' from '%s' to '%s'", TASK_EDIT),
    TASK_RELEASE_TITLE_UPDATED("Changed release title of Task '%s' from '%s' to '%s'", TASK_EDIT),
    TASK_RELEASE_TEMPLATE_UPDATED("Changed release template of Task '%s' from '%s' to '%s'", TASK_EDIT),
    TASK_START_RELEASE_FLAG_UPDATED("Changed start release flag of Task '%s' from '%s' to '%s'", TASK_EDIT),
    TASK_RELEASE_VARIABLE_UPDATED("Changed variable '%s' of Task '%s' from '%s' to '%s'", TASK_EDIT),
    TASK_RELEASE_PASSWORD_VARIABLE_UPDATED("Changed password variable '%s' of Task '%s'", TASK_EDIT),
    TASK_RELEASE_TAGS_UPDATED("Changed release tags of Task '%s' from '%s' to '%s'", TASK_EDIT),
    TASKS_LOCKED("Tasks '%s' locked", TASK_EDIT),
    TASKS_UNLOCKED("Tasks '%s' unlocked", TASK_EDIT),
    TASK_FAILURE_HANDLE_ENABLED("Changed task failure handle enabled of '%s' from '%s' to '%s'", TASK_EDIT),
    TASK_RECOVER_OP_UPDATED("Changed task recovery operation of '%s' from '%s' to '%s'", TASK_EDIT),
    TASK_RECOVER_SCRIPT_UPDATED("Changed task recovery script of '%s' from '%s' to '%s'", TASK_EDIT),
    TASK_POSTPONE_BLACKOUT_UPDATED("Changed 'Postpone during blackout' of Task '%s' from '%s' to '%s'", TASK_EDIT),
    TASK_CHECK_ATTRIBUTES_UPDATED("Changed 'Check environment availability' of Task '%s' from '%s' to '%s'", TASK_EDIT),
    TASK_TAGS_UPDATED("Changed tags of Task '%s' from '%s' to: '%s'", TASK_EDIT),
    TEAM_CREATED("Created Team '%s'", SECURITY, RELEASE_EDIT),
    TEAM_UPDATED("Updated Team '%s' with members '%s' and roles '%s'", REASSIGN, SECURITY),
    TEAM_DELETED("Removed Team '%s'", SECURITY, RELEASE_EDIT),
    FOLDER_TEAM_MERGED("Merged teams and permissions from template %s into folder %s", SECURITY, RELEASE_EDIT),
    REMOVE_TEMPLATE_TEAMS("Removed teams from template %s. It will inherit teams and permissions from folder %s", SECURITY, RELEASE_EDIT),
    TASK_WATCHER_ADDED("Added watcher '%s' to task '%s'", TASK_EDIT),
    TASK_WATCHER_REMOVED("Removed watcher '%s' from task '%s'", TASK_EDIT),

    GATE_CONDITION_CREATED("Created Condition '%s' on gate '%s'", TASK_EDIT),
    GATE_CONDITION_TITLE_UPDATED("Updated title on Condition '%s' of gate '%s' from '%s' to '%s'", TASK_EDIT),
    GATE_CONDITION_FULFILLED("Fulfilled Condition '%s' on gate '%s'", TASK_EDIT, LIFECYCLE),
    GATE_CONDITION_UNFULFILLED("Unfulfilled Condition '%s' on gate '%s'", TASK_EDIT, LIFECYCLE),
    GATE_CONDITION_DELETED("Deleted Condition '%s' from gate '%s'", TASK_EDIT),

    LINK_ADDED("Created Link on Group '%s' from Task '%s' to Task '%s'", TASK_EDIT),
    LINK_REMOVED("Removed Link on Group '%s' from Task '%s' to Task '%s'", TASK_EDIT),

    DEPENDENCY_CREATED("Added Dependency in gate '%s' on '%s'", TASK_EDIT),
    DEPENDENCY_UPDATED("Changed Dependency in gate '%s' on '%s' to '%s'", TASK_EDIT),
    DEPENDENCY_DELETED("Deleted Dependency in gate '%s' on '%s'", TASK_EDIT),

    RELEASE_CREATED_FROM_TEMPLATE("Created Release '%s' from template '%s'", LIFECYCLE),
    WORKFLOW_EXECUTION_CREATED_FROM_TEMPLATE("Workflow execution '%s' created from template '%s'", LIFECYCLE),
    RELEASE_CREATED_FROM_CREATE_RELEASE_TASK("Created Release '%s' from create release task '%s' and template '%s'", LIFECYCLE),
    RELEASE_CREATED_FROM_DSL("Created Release '%s' from DSL", LIFECYCLE),
    WORKFLOW_EXECUTION_CREATED_FROM_DSL("Created Workflow execution '%s' from Groovy (DSL)", LIFECYCLE),
    WORKFLOW_TEMPLATE_CREATED_FROM_DSL("Created Workflow template '%s' from Groovy (DSL)", LIFECYCLE),
    RELEASE_RESTORED_FROM_REVISION("Template '%s' restored from revision '%s'", LIFECYCLE),
    RELEASE_CREATED("Created Empty Release '%s'", LIFECYCLE, RELEASE_EDIT),
    RELEASE_STARTED("Started Release", LIFECYCLE, IMPORTANT),
    WORKFLOW_EXECUTION_STARTED("Started Workflow execution", LIFECYCLE, IMPORTANT),
    RELEASE_STARTED_FROM_CREATE_RELEASE_TASK("Started Release '%s' from create release task '%s'", LIFECYCLE),
    RELEASE_FAILED("Failed Release", LIFECYCLE),
    WORKFLOW_EXECUTION_FAILED("Failed Workflow execution", LIFECYCLE),
    RELEASE_FAILING("Release started failing", LIFECYCLE),
    WORKFLOW_EXECUTION_FAILING("Workflow execution started failing", LIFECYCLE),
    RELEASE_RESTARTED("Restarted Release", LIFECYCLE),
    WORKFLOW_EXECUTION_RESTARTED("Restarted Workflow execution", LIFECYCLE),
    RELEASE_COMPLETED("Completed Release", LIFECYCLE, IMPORTANT),
    WORKFLOW_EXECUTION_COMPLETED("Completed Workflow execution", LIFECYCLE, IMPORTANT),
    RELEASE_ABORTED("Aborted Release with comment '%s'", LIFECYCLE, IMPORTANT),
    WORKFLOW_EXECUTION_ABORTED("Aborted Workflow execution with comment '%s'", LIFECYCLE, IMPORTANT),

    TASK_STARTED("Started Task '%s'", LIFECYCLE),
    TASK_DELAYED("Activated Task '%s' with a scheduled start date of '%s'", LIFECYCLE),
    TASK_DELAYED_DUE_TO_BLACKOUT("Activated Task '%s' with a scheduled start date of '%s' due to a blackout", LIFECYCLE),
    TASK_COMPLETED("Completed Task '%s'", LIFECYCLE),
    TASK_COMPLETED_IN_ADVANCE("Completed in advance Task '%s'", LIFECYCLE),
    TASK_SKIPPED("Skipped Task '%s'", LIFECYCLE, IMPORTANT),
    TASK_SKIPPED_IN_ADVANCE("Skipped in advance Task '%s'", LIFECYCLE, IMPORTANT),
    TASK_FAILED("Failed Task '%s': %s", LIFECYCLE, IMPORTANT),
    TASK_RESTARTED("Restarted Task '%s'", LIFECYCLE),
    TASK_FAILING("Task '%s' started failing", LIFECYCLE),
    TASK_REOPENED("Task '%s' reopened", LIFECYCLE),
    TASK_RECOVERY_STARTED("Task '%s' started recovering. Recovery operation: '%s', failure handler script is %s", LIFECYCLE, IMPORTANT),
    TASK_RECOVERED("Task '%s' recovery complete. Recovery operation: '%s', failure handler script was %s", LIFECYCLE, IMPORTANT),
    TASK_ABORT_SCRIPT_STARTED("Abort script of task '%s' started. Abort script is %s", LIFECYCLE, IMPORTANT),
    TASK_ABORT_SCRIPT_COMPLETED("Abort script of task '%s' completed. Abort script is %s", LIFECYCLE, IMPORTANT),
    TASK_WAITING_FOR_INPUT("Task %s' requires input for variables: %s", LIFECYCLE),

    TEMPLATE_IMPORTED("Imported template", RELEASE_EDIT),

    PERMISSIONS_UPDATED("Updated permissions to:\n%s", SECURITY),

    ATTACHMENT_ADDED("Added attachment: '%s' (%s)", RELEASE_EDIT),
    ATTACHMENT_ADDED_ON_TASK("Added attachment: '%s' (%s) on task: '%s'", RELEASE_EDIT),
    ATTACHMENT_DELETED("Deleted attachment: '%s'", RELEASE_EDIT),
    ATTACHMENT_DELETED_FROM_TASK("Deleted attachment: '%s' from task : '%s'", RELEASE_EDIT),

    TEMPLATE_LOGO_UPDATED("Updated logo: '%s' (%s)", RELEASE_EDIT),

    TEMPLATE_ALLOW_CONCURRENT_RELEASES_FROM_TRIGGER_UPDATED("Changed 'Allow concurrent triggered releases' from '%s' to '%s'", RELEASE_EDIT),

    RELEASE_VARIABLE_CREATED("Created variable %s", RELEASE_EDIT),
    RELEASE_VARIABLE_DELETED("Deleted variable %s", RELEASE_EDIT),
    RELEASE_VARIABLE_REPLACED("Replaced variable %s with %s", RELEASE_EDIT),
    RELEASE_VARIABLE_RENAMED("Renamed variable '%s' to '%s'", RELEASE_EDIT),

    RELEASE_VARIABLE_VALUE_UPDATED("Changed value of variable %s from '%s' to '%s'", RELEASE_EDIT),
    RELEASE_VARIABLE_PASSWORD_VALUE_UPDATED("Changed value of password variable %s", RELEASE_EDIT),
    RELEASE_VARIABLE_NAME_UPDATED("Changed name of variable %s from '%s' to '%s'", RELEASE_EDIT),
    RELEASE_VARIABLE_LABEL_UPDATED("Changed label of variable %s from '%s' to '%s'", RELEASE_EDIT),
    RELEASE_VARIABLE_DESCRIPTION_UPDATED("Changed description of variable %s from '%s' to '%s'", RELEASE_EDIT),
    RELEASE_VARIABLE_REQUIRED_UPDATED("Changed required flag of variable %s from %s to %s", RELEASE_EDIT),
    RELEASE_VARIABLE_SHOW_ON_CREATE_UPDATED("Changed 'show on create release form' flag of variable %s from %s to %s", RELEASE_EDIT),

    GLOBAL_VARIABLE_CREATED("Created global variable %s", RELEASE_EDIT),
    GLOBAL_VARIABLE_VALUE_UPDATED("Changed value of global variable %s from '%s' to '%s'", RELEASE_EDIT),
    GLOBAL_VARIABLE_PASSWORD_VALUE_UPDATED("Changed value of global password variable %s", RELEASE_EDIT),
    GLOBAL_VARIABLE_NAME_UPDATED("Changed name of global variable %s from '%s' to '%s'", RELEASE_EDIT),
    GLOBAL_VARIABLE_LABEL_UPDATED("Changed label of global variable %s from '%s' to '%s'", RELEASE_EDIT),
    GLOBAL_VARIABLE_DESCRIPTION_UPDATED("Changed description of global variable %s from '%s' to '%s'", RELEASE_EDIT),
    GLOBAL_VARIABLE_DELETED("Deleted global variable %s", RELEASE_EDIT),

    FOLDER_VARIABLE_CREATED("Created folder variable %s", RELEASE_EDIT),
    FOLDER_VARIABLE_VALUE_UPDATED("Changed value of folder variable %s from '%s' to '%s'", RELEASE_EDIT),
    FOLDER_VARIABLE_PASSWORD_VALUE_UPDATED("Changed value of folder password variable %s", RELEASE_EDIT),
    FOLDER_VARIABLE_DELETED("Deleted folder variable %s", RELEASE_EDIT),
    FOLDER_VARIABLE_NAME_UPDATED("Changed name of folder variable %s from '%s' to '%s'", RELEASE_EDIT),
    FOLDER_VARIABLE_LABEL_UPDATED("Changed label of folder variable %s from '%s' to '%s'", RELEASE_EDIT),
    FOLDER_VARIABLE_DESCRIPTION_UPDATED("Changed description of folder variable %s from '%s' to '%s'", RELEASE_EDIT),
    RELEASE_RISK_PROFILE_UPDATED("Changed risk profile from '%s' to '%s'", RELEASE_EDIT),

    TASK_REPORTING_RECORD_CREATED("Created reporting record of type %s", REPORTING_RECORD_EDIT),

    // This is only used during deserialization, as a fallback for obsolete activity names that don't exist anymore as an enum value.
    OTHER("", ActivityCategory.OTHER),

    CUSTOM("%s", ActivityCategory.OTHER);

    private String message;
    private Set<ActivityCategory> categories;

    ReleaseActivity(String message, ActivityCategory... categories) {
        this.message = message;
        Set<ActivityCategory> myCategories = newLinkedHashSet();
        if (categories != null) {
            Collections.addAll(myCategories, categories);
        }
        this.categories = Collections.unmodifiableSet(myCategories);
    }

    public ActivityLogEntry create(Date eventTime, String username, Type targetType, String targetId, Object... parameters) {
        return create(eventTime, name(), username, targetType, targetId, message, parameters);
    }

    public ActivityLogEntry create(XLReleaseEvent event, BaseConfigurationItem target, Object... parameters) {
        return create(event.timestamp(), event.username(), target.getType(), target.getId(), parameters);
    }

    @Override
    public String getName() {
        return name();
    }

    public Set<ActivityCategory> getCategories() {
        return categories;
    }

    @Override
    public String toString() {
        return message;
    }

    private static final Map<String, ReleaseActivity> BY_NAME;

    static {
        ImmutableMap.Builder<String, ReleaseActivity> builder = ImmutableMap.builder();
        for (ReleaseActivity value : ReleaseActivity.values()) {
            builder.put(value.name(), value);
        }
        BY_NAME = builder.build();
    }

    public static ReleaseActivity safeValueOf(String name) {
        ReleaseActivity activity = BY_NAME.get(name);
        return (activity == null ? OTHER : activity);
    }


}
