package com.xebialabs.xlrelease.repository;

import java.util.Date;
import java.util.Collections;
import java.util.List;

import org.springframework.data.domain.Pageable;

import com.xebialabs.xlrelease.activity.ActivityOps;
import com.xebialabs.xlrelease.domain.ActivityLogEntry;
import com.xebialabs.xlrelease.user.User;
import com.xebialabs.xlrelease.views.LogsFilters;

import static com.google.common.collect.Lists.newArrayList;
import static com.xebialabs.xlrelease.user.User.AUTHENTICATED_USER;

public interface ActivityLogRepository {

    default void log(String containerId, ActivityLogEntry activityLogEntry) {
        log(containerId, activityLogEntry, AUTHENTICATED_USER);
    }

    default void log(String containerId, ActivityLogEntry activityLogEntry, User user) {
        log(containerId, newArrayList(activityLogEntry), user);
    }

    default void log(String containerId, ActivityLogEntry activityLogEntry, String username) {
        log(containerId, newArrayList(activityLogEntry), username);
    }

    default void log(String containerId, List<ActivityLogEntry> activityLogEntries) {
        log(containerId, activityLogEntries, AUTHENTICATED_USER);
    }

    default void log(String containerId, List<ActivityLogEntry> activityLogEntries, User user) {
        log(containerId, activityLogEntries, user.getName());
    }

    void log(String containerId, List<ActivityLogEntry> activityLogEntries, String username);

    List<ActivityLogEntry> findAllLogsOf(String containerId, final LogsFilters logsFilters, final List<? extends ActivityOps> knownActivityOps, final Pageable pageable);

    List<ActivityLogEntry> findAllLogsOf(String containerId, ActivityOps activityOps, final Pageable pageable);

    default List<ActivityLogEntry> findAllLogsOf(String containerId) {
        return findAllLogsOf(containerId, null, Collections.emptyList(), Pageable.unpaged());
    }


    void move(String fromContainerId, String toContainerId);

    void delete(String containerId);

    void deleteByActivityTypesAndDate(List<ActivityOps> activityTypes, Date date);

}
