/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api.v1.impl;

import com.xebialabs.xlrelease.api.v1.ActivityLogsApi;
import com.xebialabs.xlrelease.domain.ActivityLogEntry;
import com.xebialabs.xlrelease.handler.BaseActivityLogsApiHandler;
import com.xebialabs.xlrelease.repository.Ids;
import io.micrometer.core.annotation.Timed;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Controller;

@Controller
public class ActivityLogsApiImpl
implements ActivityLogsApi {
    private static Map<String, BaseActivityLogsApiHandler> apiHandlerMap = new HashMap<String, BaseActivityLogsApiHandler>();

    @Timed
    public List<ActivityLogEntry> getActivityLogs(String containerId) {
        if (Ids.isReleaseId((String)containerId)) {
            return this.getActivityLogs("release", containerId);
        }
        if (Ids.isDeliveryId((String)containerId)) {
            return this.getActivityLogs("delivery", containerId);
        }
        if (Ids.isTriggerId((String)containerId)) {
            return this.getActivityLogs("trigger", containerId);
        }
        throw new IllegalArgumentException(String.format("Could not get activity logs for '%s'", containerId));
    }

    public static void registerApiHandler(String handlerName, BaseActivityLogsApiHandler baseActivityLogsApiHandler) {
        apiHandlerMap.put(handlerName, baseActivityLogsApiHandler);
    }

    private List<ActivityLogEntry> getActivityLogs(String handlerName, String containerId) {
        if (apiHandlerMap.containsKey(handlerName)) {
            return apiHandlerMap.get(handlerName).getActivityLogs(containerId);
        }
        throw new IllegalStateException(String.format("No API handler registered to get %s activity logs.", handlerName));
    }
}

