package com.xebialabs.xlrelease.activity

import com.xebialabs.xlrelease.domain.ReleaseActivity.TEMPLATE_LOGO_UPDATED
import com.xebialabs.xlrelease.domain.events._
import com.xebialabs.xlrelease.events.{EventListener, Subscribe, XLReleaseEventBus}
import com.xebialabs.xlrelease.repository.ActivityLogRepository
import com.xebialabs.xlrelease.repository.Ids.isReleaseId
import org.springframework.stereotype.Component

@Component
@EventListener
class TemplateLogoActivityLoggingEventHandler(val eventBus: XLReleaseEventBus,
                                              val activityLogRepository: ActivityLogRepository) extends ActivityLogger[TemplateLogoEvent] {

  @Subscribe
  def onEvent(event: TemplateLogoEvent): Unit = log(event)

  def logEntries: PartialFunction[XLReleaseEvent, LoggingParams] = {
    case ev@TemplateLogoUpdatedEvent(templateId, templateLogo) if isReleaseId(templateId) =>
      LoggingParams(Some(templateId), None, TEMPLATE_LOGO_UPDATED.create(ev, templateLogo, templateLogo.getFile.getName, templateLogo.getContentType))
  }

}
