package com.xebialabs.xlrelease.activity

import com.xebialabs.xlrelease.domain.ReleaseActivity.{COMMENT_ADDED, COMMENT_DELETED, COMMENT_UPDATED}
import com.xebialabs.xlrelease.domain.events._
import com.xebialabs.xlrelease.events.{EventListener, Subscribe, XLReleaseEventBus}
import com.xebialabs.xlrelease.repository.ActivityLogRepository
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Component

@Component
@EventListener
class CommentActivityLoggingEventHandler @Autowired()(val eventBus: XLReleaseEventBus, val activityLogRepository: ActivityLogRepository)
  extends ActivityLogger[CommentEvent] {

  @Subscribe
  def onEvent(event: CommentEvent): Unit = log(event)

  def logEntries = {
    case ev@CommentCreatedEvent(task, comment, author, _) =>
      LoggingParams(releaseIdFrom(task), Some(author), COMMENT_ADDED.create(ev, ev.comment, comment.getText, task.getTitle))

    case ev@CommentUpdatedEvent(task, original, updated) =>
      LoggingParams(releaseIdFrom(task), None, COMMENT_UPDATED.create(ev, ev.original, original.getText, updated.getText, task.getTitle))

    case ev@CommentDeletedEvent(task, comment) =>
      LoggingParams(releaseIdFrom(task), None, COMMENT_DELETED.create(ev, ev.comment, comment.getText, task.getTitle))
  }
}
