package com.xebialabs.xlrelease.activity;

import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.xlrelease.domain.ActivityLogEntry;
import com.xebialabs.xlrelease.domain.CustomScriptTask;
import com.xebialabs.xlrelease.domain.PythonScript;
import com.xebialabs.xlrelease.domain.Task;

import static com.google.common.base.Objects.equal;
import static com.xebialabs.xlrelease.domain.ReleaseActivity.TASK_INPUT_PROPERTY_PASSWORD_UPDATED;
import static com.xebialabs.xlrelease.domain.ReleaseActivity.TASK_INPUT_PROPERTY_UPDATED;
import static com.xebialabs.xlrelease.domain.ReleaseActivity.TASK_OUTPUT_PROPERTIES_UPDATED;

@Component
public class CustomScriptTaskFieldsComparator implements TaskFieldsComparator<CustomScriptTask> {

    private DefaultTaskFieldsComparator defaultTaskFieldsComparator;

    @Autowired
    public CustomScriptTaskFieldsComparator(final DefaultTaskFieldsComparator defaultTaskFieldsComparator) {
        this.defaultTaskFieldsComparator = defaultTaskFieldsComparator;
    }

    @Override
    public Class<CustomScriptTask> getTaskClass() {
        return CustomScriptTask.class;
    }

    @Override
    public List<ActivityLogEntry> getLogs(Date timestamp, String username, final CustomScriptTask original, final CustomScriptTask updated) {
        List<ActivityLogEntry> updateLogs = defaultTaskFieldsComparator.getLogs(timestamp, username, original, updated);
        PythonScript pythonScript = original.getPythonScript();
        PythonScript updatedPythonScript = updated.getPythonScript();

        for (PropertyDescriptor propertyDescriptor : pythonScript.getInputProperties()) {
            String propertyName = propertyDescriptor.getName();

            if (propertyDescriptor.isPassword()) {
                comparePasswordProperty(timestamp, username, updateLogs, updated, pythonScript, propertyDescriptor, propertyName);
            } else {
                compareProperty(timestamp, username, updateLogs, updated, pythonScript, propertyDescriptor, propertyName);
            }
        }

        for (PropertyDescriptor propertyDescriptor : pythonScript.getOutputProperties()) {
            String propertyName = propertyDescriptor.getName();

            Object oldValue = pythonScript.getProperty(propertyName);
            Object newValue = updatedPythonScript.getProperty(propertyName);

            if (!equal(oldValue, newValue)) {
                updateLogs.add(TASK_OUTPUT_PROPERTIES_UPDATED.create(timestamp, username, original.getType(), original.getId(),
                        propertyDescriptor.getLabel(), updated.getTitle(), oldValue, newValue)
                );
            }
        }

        return updateLogs;
    }

    private void comparePasswordProperty(Date timestamp, String username, List<ActivityLogEntry> logEntries,
                                         Task updated, PythonScript pythonScript, PropertyDescriptor propertyDescriptor, String propertyName) {
        Object oldValue = pythonScript.getProperty(propertyName);
        Object newValue = ((CustomScriptTask) updated).getPythonScript().getProperty(propertyName);

        if (!equal(oldValue, newValue)) {
            logEntries.add(TASK_INPUT_PROPERTY_PASSWORD_UPDATED.create(timestamp, username, updated.getType(), updated.getId(),
                    propertyDescriptor.getLabel(), updated.getTitle())
            );
        }
    }

    private void compareProperty(Date timestamp, String username, List<ActivityLogEntry> logEntries,
                                 Task updated, PythonScript pythonScript, PropertyDescriptor propertyDescriptor, String propertyName) {
        Object oldValue = pythonScript.getProperty(propertyName);
        Object newValue = ((CustomScriptTask) updated).getPythonScript().getProperty(propertyName);

        if (!equal(oldValue, newValue)) {
            logEntries.add(TASK_INPUT_PROPERTY_UPDATED.create(timestamp, username, updated.getType(), updated.getId(),
                    propertyDescriptor.getLabel(), updated.getTitle(), oldValue, newValue)
            );
        }
    }
}
