package com.xebialabs.xlrelease.activity

import com.xebialabs.xlrelease.domain.ReleaseActivity
import com.xebialabs.xlrelease.domain.events.{FacetConfiguredFacetsCreatedEvent, XLReleaseEvent}
import com.xebialabs.xlrelease.events.{EventListener, Subscribe, XLReleaseEventBus}
import com.xebialabs.xlrelease.repository.ActivityLogRepository
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Component

import scala.jdk.CollectionConverters._

@Component
@EventListener
class TaskReportingRecordActivityLoggingEventHandler @Autowired()(val eventBus: XLReleaseEventBus, val activityLogRepository: ActivityLogRepository)
  extends ActivityLogger[FacetConfiguredFacetsCreatedEvent] {

  @Subscribe
  def onEvent(event: FacetConfiguredFacetsCreatedEvent): Unit = log(event)

  override def logEntries: PartialFunction[XLReleaseEvent, LoggingParams] = {
    case ev@FacetConfiguredFacetsCreatedEvent(originalFacet, configuredFacets, _) =>
      LoggingParams(releaseIdFrom(originalFacet.getTargetId), Option(ev.username),
        configuredFacets.asScala.map(f => ReleaseActivity.TASK_REPORTING_RECORD_CREATED.create(ev, ev.originalFacet, dropPrefix(f.getType.toString))).toList
      )
  }

  private def dropPrefix(facetType: String): String = Option(facetType).map(s => s.substring(s.indexOf(".") + 1)).getOrElse(facetType)

}
