package com.xebialabs.xlrelease.activity

import com.xebialabs.xlrelease.domain.ReleaseActivity.{ATTACHMENT_ADDED, ATTACHMENT_ADDED_ON_TASK, ATTACHMENT_DELETED, ATTACHMENT_DELETED_FROM_TASK}
import com.xebialabs.xlrelease.domain.events._
import com.xebialabs.xlrelease.events.{EventListener, Subscribe, XLReleaseEventBus}
import com.xebialabs.xlrelease.repository.ActivityLogRepository
import com.xebialabs.xlrelease.repository.Ids.isReleaseId
import com.xebialabs.xlrelease.service.TaskService
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Component

@Component
@EventListener
class AttachmentActivityLoggingEventHandler @Autowired()(val eventBus: XLReleaseEventBus,
                                                         val activityLogRepository: ActivityLogRepository,
                                                         taskService: TaskService) extends ActivityLogger[AttachmentEvent] {

  @Subscribe
  def onEvent(event: AttachmentEvent): Unit = log(event)

  def logEntries: PartialFunction[XLReleaseEvent, LoggingParams] = {
    case ev@AttachmentCreatedEvent(releaseId, attachment) if isReleaseId(releaseId) =>
      LoggingParams(Some(releaseId), None, ATTACHMENT_ADDED.create(ev, ev.attachment, attachment.getFile.getName, attachment.getContentType))

    case ev@AttachmentCreatedEvent(taskId, attachment) =>
      LoggingParams(releaseIdFrom(taskId), None,
        ATTACHMENT_ADDED_ON_TASK.create(ev, ev.attachment, attachment.getFile.getName, attachment.getContentType, taskService.getTitle(taskId))
      )

    case ev@AttachmentDeletedEvent(releaseId, attachment) if isReleaseId(releaseId) =>
      LoggingParams(Some(releaseId), None, ATTACHMENT_DELETED.create(ev, ev.attachment, attachment.getFile.getName))

    case ev@AttachmentDeletedEvent(taskId, attachment) =>
      LoggingParams(releaseIdFrom(taskId), None, ATTACHMENT_DELETED_FROM_TASK.create(ev, ev.attachment, attachment.getFile.getName, taskService.getTitle(taskId)))
  }

}
