package com.xebialabs.xlrelease.api.internal;

import java.util.List;

import org.springframework.data.domain.Pageable;

import com.xebialabs.xlrelease.domain.ActivityLogEntry;
import com.xebialabs.xlrelease.service.BaseActivityLogsService;
import com.xebialabs.xlrelease.views.ActivityLogEntryView;
import com.xebialabs.xlrelease.views.LogsFilters;
import com.xebialabs.xlrelease.views.UserView;
import com.xebialabs.xlrelease.views.converters.UserViewConverter;

import static java.util.stream.Collectors.toList;

public abstract class BaseActivityLogsResource {

    private BaseActivityLogsService baseActivityLogsService;
    private UserViewConverter userViewConverter;

    public BaseActivityLogsResource(
            final BaseActivityLogsService baseActivityLogsService,
            final UserViewConverter userViewConverter) {
        this.baseActivityLogsService = baseActivityLogsService;
        this.userViewConverter = userViewConverter;
    }

    protected List<ActivityLogEntryView> searchLogs(String containerId, LogsFilters filters, final Pageable pageable) {
        return baseActivityLogsService.getFilteredLogs(containerId, filters, pageable).stream()
                .map(this::toActivityLogEntryView)
                .collect(toList());
    }

    protected ActivityLogEntryView toActivityLogEntryView(ActivityLogEntry activityLogEntry) {
        String username = activityLogEntry.hasUsername() ? activityLogEntry.getUsername() : "SYSTEM";
        UserView user = userViewConverter.toUserView(username);
        return new ActivityLogEntryView(
                user,
                activityLogEntry.getActivityType(),
                activityLogEntry.getMessage(),
                activityLogEntry.getEventTime(),
                activityLogEntry.getTargetType(),
                activityLogEntry.getTargetId(),
                activityLogEntry.getDataId()
        );
    }

}
