package com.xebialabs.xlrelease.activity;

import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.xebialabs.xlrelease.domain.ActivityLogEntry;
import com.xebialabs.xlrelease.domain.NotificationTask;

import static com.google.common.base.Objects.equal;
import static com.google.common.collect.Sets.newHashSet;
import static com.xebialabs.xlrelease.domain.ReleaseActivity.TASK_NOTIFICATION_ADDRESSES_UPDATED;
import static com.xebialabs.xlrelease.domain.ReleaseActivity.TASK_NOTIFICATION_BCC_UPDATED;
import static com.xebialabs.xlrelease.domain.ReleaseActivity.TASK_NOTIFICATION_BODY_UPDATED;
import static com.xebialabs.xlrelease.domain.ReleaseActivity.TASK_NOTIFICATION_CC_UPDATED;
import static com.xebialabs.xlrelease.domain.ReleaseActivity.TASK_NOTIFICATION_FROM_UPDATED;
import static com.xebialabs.xlrelease.domain.ReleaseActivity.TASK_NOTIFICATION_PRIORITY_UPDATED;
import static com.xebialabs.xlrelease.domain.ReleaseActivity.TASK_NOTIFICATION_REPLY_TO_UPDATED;
import static com.xebialabs.xlrelease.domain.ReleaseActivity.TASK_NOTIFICATION_SENDER_PASSWORD_UPDATED;
import static com.xebialabs.xlrelease.domain.ReleaseActivity.TASK_NOTIFICATION_SENDER_USERNAME_UPDATED;
import static com.xebialabs.xlrelease.domain.ReleaseActivity.TASK_NOTIFICATION_SUBJECT_UPDATED;

@Component
public class NotificationTaskFieldsComparator implements TaskFieldsComparator<NotificationTask> {

    private DefaultTaskFieldsComparator defaultTaskFieldsComparator;

    @Autowired
    public NotificationTaskFieldsComparator(final DefaultTaskFieldsComparator defaultTaskFieldsComparator) {
        this.defaultTaskFieldsComparator = defaultTaskFieldsComparator;
    }

    @Override
    public Class<NotificationTask> getTaskClass() {
        return NotificationTask.class;
    }

    @Override
    public List<ActivityLogEntry> getLogs(Date timestamp, String username, final NotificationTask original, final NotificationTask updated) {
        List<ActivityLogEntry> updateLogs = defaultTaskFieldsComparator.getLogs(timestamp, username, original, updated);

        if (!equal(original.getAddresses(), updated.getAddresses())) {
            updateLogs.add(TASK_NOTIFICATION_ADDRESSES_UPDATED.create(
                    timestamp,
                    username,
                    original.getTaskType(),
                    original.getId(),
                    updated.getTitle(),
                    original.getAddresses() != null ? newHashSet(original.getAddresses()) : null,
                    updated.getAddresses())
            );
        }

        if (!equal(original.getSubject(), updated.getSubject())) {
            updateLogs.add(TASK_NOTIFICATION_SUBJECT_UPDATED.create(timestamp, username, original.getTaskType(), original.getId(),
                    updated.getTitle(), original.getSubject(), updated.getSubject())
            );
        }

        if (!equal(original.getBody(), updated.getBody())) {
            updateLogs.add(TASK_NOTIFICATION_BODY_UPDATED.create(timestamp, username, original.getTaskType(), original.getId(),
                    updated.getTitle(), original.getBody(), updated.getBody())
            );
        }

        if (!equal(original.getCc(), updated.getCc())) {
            updateLogs.add(TASK_NOTIFICATION_CC_UPDATED.create(timestamp, username, original.getTaskType(), original.getId(),
                    updated.getTitle(), original.getCc(), updated.getCc())
            );
        }

        if (!equal(original.getBcc(), updated.getBcc())) {
            updateLogs.add(TASK_NOTIFICATION_BCC_UPDATED.create(timestamp, username, original.getTaskType(), original.getId(),
                    updated.getTitle(), original.getBcc(), updated.getBcc())
            );
        }

        if (!equal(original.getReplyTo(), updated.getReplyTo())) {
            updateLogs.add(TASK_NOTIFICATION_REPLY_TO_UPDATED.create(timestamp, username, original.getTaskType(), original.getId(),
                    updated.getTitle(), original.getReplyTo(), updated.getReplyTo())
            );
        }

        if (!equal(original.getFrom(), updated.getFrom())) {
            updateLogs.add(TASK_NOTIFICATION_FROM_UPDATED.create(timestamp, username, original.getTaskType(), original.getId(),
                    updated.getTitle(), original.getFrom(), updated.getFrom()));
        }

        if (!equal(original.getSenderUsername(), updated.getSenderUsername())) {
            updateLogs.add(TASK_NOTIFICATION_SENDER_USERNAME_UPDATED.create(timestamp, username, original.getTaskType(), original.getId(),
                    updated.getTitle(), original.getSenderUsername(), updated.getSenderUsername()));
        }

        if (!equal(original.getSenderPassword(), updated.getSenderPassword())) {
            updateLogs.add(TASK_NOTIFICATION_SENDER_PASSWORD_UPDATED.create(timestamp, username, original.getTaskType(), original.getId(),
                    updated.getTitle()));
        }

        if (!equal(original.getPriority(), updated.getPriority())) {
            updateLogs.add(TASK_NOTIFICATION_PRIORITY_UPDATED.create(timestamp, username, original.getTaskType(), original.getId(),
                    updated.getTitle(), original.getPriority(), updated.getPriority())
            );
        }

        return updateLogs;
    }
}
