package com.xebialabs.xlrelease.handler

import com.xebialabs.xlrelease.domain.ActivityLogEntry
import com.xebialabs.xlrelease.security.PermissionChecker
import com.xebialabs.xlrelease.service.ReleaseActivityLogsService
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Component

import java.util.{List => JList}

@Component
class ReleaseActivityLogsApiHandler @Autowired()(releaseActivityLogsService: ReleaseActivityLogsService, permissions: PermissionChecker)
  extends BaseActivityLogsApiHandler(releaseActivityLogsService, "release") {

  override def getActivityLogs(releaseId: String): JList[ActivityLogEntry] = {
    permissions.checkView(releaseId)
    searchLogs(releaseId)
  }
}
