package com.xebialabs.xlrelease.activity

import com.xebialabs.xlrelease.domain.ReleaseActivity
import com.xebialabs.xlrelease.domain.events._
import com.xebialabs.xlrelease.events.{EventListener, Subscribe, XLReleaseEventBus}
import com.xebialabs.xlrelease.repository.ActivityLogRepository
import com.xebialabs.xlrelease.variable.VariableHelper.withVariableSyntax
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Component

@Component
@EventListener
class FolderVariableActivityLoggingEventHandler @Autowired()(val eventBus: XLReleaseEventBus, val activityLogRepository: ActivityLogRepository)
  extends ActivityLogger[FolderVariableEvent] {

  @Subscribe
  def onEvent(event: FolderVariableEvent): Unit = log(event)

  override def logEntries: PartialFunction[XLReleaseEvent, LoggingParams] = {
    case ev@FolderVariableCreatedEvent(variable, ModifiedFromScriptTask(taskId)) =>
      LoggingParams(releaseIdFrom(taskId), None,
        ReleaseActivity.FOLDER_VARIABLE_CREATED.create(ev, ev.variable, withVariableSyntax(variable.getKey))
      )

    case ev@FolderVariableDeletedEvent(variable, ModifiedFromScriptTask(taskId)) =>
      LoggingParams(releaseIdFrom(taskId), None,
        ReleaseActivity.FOLDER_VARIABLE_DELETED.create(ev, ev.variable, withVariableSyntax(variable.getKey))
      )

    case ev@FolderVariableUpdatedEvent(original, updated, ModifiedFromScriptTask(taskId)) =>
      if (updated.isPassword) {
        LoggingParams(releaseIdFrom(taskId), None,
          ReleaseActivity.FOLDER_VARIABLE_PASSWORD_VALUE_UPDATED.create(ev, ev.original, withVariableSyntax(original.getKey))
        )
      } else {
        LoggingParams(releaseIdFrom(taskId), None,
          ReleaseActivity.FOLDER_VARIABLE_VALUE_UPDATED.create(ev, ev.original,
            withVariableSyntax(original.getKey), original.getValueAsString, updated.getValueAsString
          )
        )
      }
  }
}
