package com.xebialabs.xlrelease.activity;

public class DurationFormatter {
    static final int ONE_MINUTE = 60;
    static final int ONE_HOUR = 60 * ONE_MINUTE;
    static final int ONE_DAY = 24 * ONE_HOUR;

    private DurationFormatter() {
        // hide constructor
    }

    public static String formatDuration(Integer duration) {
        if (duration == null) {
            return "";
        }

        int durationInMin = (int) Math.round((double) duration / 60.0);
        int durationInHour = durationInMin / 60;
        int durationInDay = durationInHour / 24;

        if (durationInMin == 0 && durationInHour == 0 && durationInDay == 0) {
            return "0 days";
        }

        int hours = durationInHour % 24;
        int minutes = durationInMin % 60;

        String formatted = (durationInDay != 0) ? durationInDay + " days" : "";
        if (hours != 0 || minutes != 0) {
            formatted += " " + twoDigit(hours) + ":" + twoDigit(minutes);
        }

        return formatted.trim();
    }

    private static String twoDigit(int number) {
        return String.format("%02d", number);
    }
}
