package com.xebialabs.xlrelease.activity;

import com.xebialabs.xlrelease.service.UserInfoResolver;

public class ReleaseActivityUserFormatter {
    private static final String UNASSIGNED_PLACEHOLDER = "unassigned";

    public static String quoteUser(String username, UserInfoResolver userInfoResolver) {
        String assignee = userInfoResolver.getFullNameOrUsernameOf(username);
        return quoteAssignee(assignee);
    }

    public static String quoteAssignee(String assignee) {
        return assignee != null ? "'" + assignee + "'" : UNASSIGNED_PLACEHOLDER;
    }
}
