package com.xebialabs.xlrelease.activity

import com.xebialabs.xlrelease.domain.ReleaseActivity._
import com.xebialabs.xlrelease.domain.events._
import com.xebialabs.xlrelease.events.{EventListener, Subscribe, XLReleaseEventBus}
import com.xebialabs.xlrelease.repository.ActivityLogRepository
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Component

@Component
@EventListener
class LinkActivityLoggingEventHandler @Autowired()(val eventBus: XLReleaseEventBus, val activityLogRepository: ActivityLogRepository)
  extends ActivityLogger[LinkEvent] {

  @Subscribe
  def onEvent(event: LinkEvent): Unit = log(event)

  override def logEntries = {
    case ev: LinkCreatedEvent =>
      LoggingParams(releaseIdFrom(ev.link), Option(ev.username),
        LINK_ADDED.create(ev, ev.link, ev.link.getParallelGroup.getTitle, ev.link.getSource.getTitle, ev.link.getTarget.getTitle)
      )
    case ev: LinkDeletedEvent =>
      LoggingParams(releaseIdFrom(ev.link), Option(ev.username),
        LINK_REMOVED.create(ev, ev.link, ev.link.getParallelGroup.getTitle, ev.link.getSource.getTitle, ev.link.getTarget.getTitle)
      )
  }

}
