/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.core.xml.WriteWithoutPasswordCiConverter;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.xlrelease.db.ArchivedReleases;
import com.xebialabs.xlrelease.domain.ActivityLogEntry;
import com.xebialabs.xlrelease.domain.ReleaseActivity;
import com.xebialabs.xlrelease.repository.ActivityLogRepository;
import com.xebialabs.xlrelease.serialization.json.utils.CiSerializerHelper$;
import com.xebialabs.xlrelease.serialization.json.xltype.CiListJson2Reader;
import com.xebialabs.xlrelease.service.ArchivedActivityLogsSerializer;
import com.xebialabs.xltype.serialization.CiListReader;
import com.xebialabs.xltype.serialization.ConfigurationItemConverter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.Seq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;

@Service
@ScalaSignature(bytes="\u0006\u0005\u0005-a\u0001B\u0005\u000b\u0001MA\u0001B\b\u0001\u0003\u0002\u0003\u0006Ia\b\u0005\tK\u0001\u0011\t\u0011)A\u0005M!)A\u0006\u0001C\u0001[!A\u0001\t\u0001EC\u0002\u0013%\u0011\tC\u0003Q\u0001\u0011\u0005\u0011\u000bC\u0003n\u0001\u0011%a\u000eC\u0003t\u0001\u0011\u0005A\u000fC\u0003{\u0001\u0011\u00053PA\u000eBe\u000eD\u0017N^3e\u0003\u000e$\u0018N^5us2{wm]*feZL7-\u001a\u0006\u0003\u00171\tqa]3sm&\u001cWM\u0003\u0002\u000e\u001d\u0005I\u0001\u0010\u001c:fY\u0016\f7/\u001a\u0006\u0003\u001fA\t\u0011\u0002_3cS\u0006d\u0017MY:\u000b\u0003E\t1aY8n\u0007\u0001\u00192\u0001\u0001\u000b\u001b!\t)\u0002$D\u0001\u0017\u0015\u00059\u0012!B:dC2\f\u0017BA\r\u0017\u0005\u0019\te.\u001f*fMB\u00111\u0004H\u0007\u0002\u0015%\u0011QD\u0003\u0002\u001f\u0003J\u001c\u0007.\u001b<fI\u0006\u001bG/\u001b<jifdunZ:TKJL\u0017\r\\5{KJ\fQ#Y2uSZLG/\u001f'pOJ+\u0007o\\:ji>\u0014\u0018\u0010\u0005\u0002!G5\t\u0011E\u0003\u0002#\u0019\u0005Q!/\u001a9pg&$xN]=\n\u0005\u0011\n#!F!di&4\u0018\u000e^=M_\u001e\u0014V\r]8tSR|'/_\u0001\u0011CJ\u001c\u0007.\u001b<fIJ+G.Z1tKN\u0004\"a\n\u0016\u000e\u0003!R!!\u000b\u0007\u0002\u0005\u0011\u0014\u0017BA\u0016)\u0005A\t%o\u00195jm\u0016$'+\u001a7fCN,7/\u0001\u0004=S:LGO\u0010\u000b\u0004]=\u0002\u0004CA\u000e\u0001\u0011\u0015q2\u00011\u0001 \u0011\u0015)3\u00011\u0001'Q\t\u0019!\u0007\u0005\u00024}5\tAG\u0003\u00026m\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\u000b\u0005]B\u0014a\u00024bGR|'/\u001f\u0006\u0003si\nQAY3b]NT!a\u000f\u001f\u0002\u001fM\u0004(/\u001b8hMJ\fW.Z<pe.T\u0011!P\u0001\u0004_J<\u0017BA 5\u0005%\tU\u000f^8xSJ,G-\u0001\nsK2,\u0017m]3BGRLg/\u001b;z\u001fB\u001cX#\u0001\"\u0011\u0007\rC%*D\u0001E\u0015\t)e)\u0001\u0003vi&d'\"A$\u0002\t)\fg/Y\u0005\u0003\u0013\u0012\u0013A\u0001T5tiB\u00111JT\u0007\u0002\u0019*\u0011Q\nD\u0001\u0007I>l\u0017-\u001b8\n\u0005=c%a\u0004*fY\u0016\f7/Z!di&4\u0018\u000e^=\u0002\u001f\u001d,G/Q2uSZLG/\u001f'pON$\"A\u0015,\u0011\u0007\rC5\u000b\u0005\u0002L)&\u0011Q\u000b\u0014\u0002\u0011\u0003\u000e$\u0018N^5us2{w-\u00128uefDQaV\u0003A\u0002a\u000b\u0011B]3mK\u0006\u001cX-\u00133\u0011\u0005e\u0003gB\u0001._!\tYf#D\u0001]\u0015\ti&#\u0001\u0004=e>|GOP\u0005\u0003?Z\ta\u0001\u0015:fI\u00164\u0017BA1c\u0005\u0019\u0019FO]5oO*\u0011qL\u0006\u0015\u0003\u000b\u0011\u0004\"!Z6\u000e\u0003\u0019T!!N4\u000b\u0005!L\u0017aB7fiJL7m\u001d\u0006\u0003UB\t\u0001bY8eC\"\fG.Z\u0005\u0003Y\u001a\u0014Q\u0001V5nK\u0012\fQcZ3u\u0003\u000e$\u0018N^5us2{wm](qi&|g\u000e\u0006\u0002peB\u0019Q\u0003\u001d*\n\u0005E4\"AB(qi&|g\u000eC\u0003X\r\u0001\u0007\u0001,\u0001\u0004fq&\u001cHo\u001d\u000b\u0003kb\u0004\"!\u0006<\n\u0005]4\"a\u0002\"p_2,\u0017M\u001c\u0005\u0006/\u001e\u0001\r\u0001\u0017\u0015\u0003\u000f\u0011\fqc]3sS\u0006d\u0017N_3BGRLg/\u001b;z\u0019><7o\u00144\u0015\u0005ac\b\"B,\t\u0001\u0004A\u0006F\u0001\u0005eQ\t\u0001q\u0010\u0005\u0003\u0002\u0002\u0005\u001dQBAA\u0002\u0015\r\t)AO\u0001\u000bgR,'/Z8usB,\u0017\u0002BA\u0005\u0003\u0007\u0011qaU3sm&\u001cW\r")
public class ArchivedActivityLogsService
implements ArchivedActivityLogsSerializer {
    private List<ReleaseActivity> releaseActivityOps;
    private final ActivityLogRepository activityLogRepository;
    private final ArchivedReleases archivedReleases;
    private volatile boolean bitmap$0;

    private List<ReleaseActivity> releaseActivityOps$lzycompute() {
        ArchivedActivityLogsService archivedActivityLogsService = this;
        synchronized (archivedActivityLogsService) {
            if (!this.bitmap$0) {
                this.releaseActivityOps = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)Predef$.MODULE$.wrapRefArray((Object[])ReleaseActivity.values()).toList()).asJava();
                this.bitmap$0 = true;
            }
        }
        return this.releaseActivityOps;
    }

    private List<ReleaseActivity> releaseActivityOps() {
        if (!this.bitmap$0) {
            return this.releaseActivityOps$lzycompute();
        }
        return this.releaseActivityOps;
    }

    @Timed
    public List<ActivityLogEntry> getActivityLogs(String releaseId) {
        return (List)this.getActivityLogsOption(releaseId).getOrElse((Function0 & Serializable)() -> {
            throw new NotFoundException("Could not find activity logs for archived release [" + releaseId + "]", new Object[0]);
        });
    }

    private Option<List<ActivityLogEntry>> getActivityLogsOption(String releaseId) {
        return this.archivedReleases.getActivityLogs(releaseId, this.archivedReleases.getActivityLogs$default$2()).map((Function1 & Serializable)activityLogsJson -> {
            WriteWithoutPasswordCiConverter ciConverter = new WriteWithoutPasswordCiConverter();
            if (Strings.isNotBlank((String)activityLogsJson)) {
                CiListReader ciReader = CiListJson2Reader.create((String)activityLogsJson);
                return ciConverter.readCis(ciReader);
            }
            return new ArrayList();
        });
    }

    @Timed
    public boolean exists(String releaseId) {
        return this.archivedReleases.exists(releaseId);
    }

    @Timed
    public String serializeActivityLogsOf(String releaseId) {
        return CiSerializerHelper$.MODULE$.serialize(this.activityLogRepository.findAllLogsOf(releaseId), (ConfigurationItemConverter)new WriteWithoutPasswordCiConverter());
    }

    @Autowired
    public ArchivedActivityLogsService(ActivityLogRepository activityLogRepository, ArchivedReleases archivedReleases) {
        this.activityLogRepository = activityLogRepository;
        this.archivedReleases = archivedReleases;
    }
}

