package com.xebialabs.xlrelease.handler

import com.xebialabs.xlrelease.api.v1.impl.ActivityLogsApiImpl
import com.xebialabs.xlrelease.domain.ActivityLogEntry
import com.xebialabs.xlrelease.service.BaseActivityLogsService
import com.xebialabs.xlrelease.views.LogsFilters
import org.springframework.data.domain.Pageable

import java.util.{List => JList}
import javax.annotation.PostConstruct

abstract class BaseActivityLogsApiHandler(val baseActivityLogsService: BaseActivityLogsService, val handlerName: String) {

  @PostConstruct
  def init(): Unit = ActivityLogsApiImpl.registerApiHandler(handlerName, this)

  def getActivityLogs(containerId: String): JList[ActivityLogEntry]

  def searchLogs(containerId: String): JList[ActivityLogEntry] = baseActivityLogsService.getFilteredLogs(containerId, LogsFilters.ALL, Pageable.unpaged())
}
