/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api.v1;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.xlplatform.documentation.PublicApi;
import com.xebialabs.xlplatform.documentation.PublicApiMember;
import com.xebialabs.xlplatform.documentation.ShowOnlyPublicApiMembers;
import com.xebialabs.xlrelease.api.ApiService;
import com.xebialabs.xlrelease.domain.ActivityLogEntry;
import com.xebialabs.xlrelease.handler.BaseActivityLogsApiHandler;
import com.xebialabs.xlrelease.repository.Ids;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.springframework.stereotype.Controller;

@Path(value="/api/v1/activities")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Controller
@PublicApi
@ShowOnlyPublicApiMembers
public class ActivityLogsApi
implements ApiService {
    private static Map<String, BaseActivityLogsApiHandler> apiHandlerMap = new HashMap<String, BaseActivityLogsApiHandler>();

    @GET
    @Path(value="/{containerId:.*/(Release|Delivery|Trigger)[^/]*}")
    @PublicApiMember
    @Timed
    public List<ActivityLogEntry> getActivityLogs(@PathParam(value="containerId") String containerId) {
        if (Ids.isReleaseId((String)containerId)) {
            return this.getActivityLogs("release", containerId);
        }
        if (Ids.isDeliveryId((String)containerId)) {
            return this.getActivityLogs("delivery", containerId);
        }
        if (Ids.isTriggerId((String)containerId)) {
            return this.getActivityLogs("trigger", containerId);
        }
        throw new IllegalArgumentException(String.format("Could not get activity logs for '%s'", containerId));
    }

    public String serviceName() {
        return "activityLogsApi";
    }

    public static void registerApiHandler(String handlerName, BaseActivityLogsApiHandler baseActivityLogsApiHandler) {
        apiHandlerMap.put(handlerName, baseActivityLogsApiHandler);
    }

    private List<ActivityLogEntry> getActivityLogs(String handlerName, String containerId) {
        if (apiHandlerMap.containsKey(handlerName)) {
            return apiHandlerMap.get(handlerName).getActivityLogs(containerId);
        }
        throw new IllegalStateException(String.format("No API handler registered to get %s activity logs.", handlerName));
    }
}

