/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.activity;

import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.xebialabs.xlrelease.activity.DurationFormatter;
import com.xebialabs.xlrelease.activity.ReleaseActivityDateFormatter;
import com.xebialabs.xlrelease.activity.ReleaseActivityUserFormatter;
import com.xebialabs.xlrelease.activity.TaskFieldsComparator;
import com.xebialabs.xlrelease.domain.ActivityLogEntry;
import com.xebialabs.xlrelease.domain.ReleaseActivity;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.utils.Diff;
import com.xebialabs.xlrelease.service.UserInfoResolver;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import scala.collection.Iterable;
import scala.jdk.javaapi.CollectionConverters;

@Component
public class DefaultTaskFieldsComparator
implements TaskFieldsComparator<Task> {
    private UserInfoResolver userInfoResolver;

    @Autowired
    public DefaultTaskFieldsComparator(UserInfoResolver userInfoResolver) {
        this.userInfoResolver = userInfoResolver;
    }

    @Override
    public Class<Task> getTaskClass() {
        return Task.class;
    }

    @Override
    public List<ActivityLogEntry> getLogs(Date timestamp, String username, Task original, Task updated) {
        ArrayList logEntries2 = Lists.newArrayList();
        if (!Objects.equal((Object)original.getTitle(), (Object)updated.getTitle())) {
            logEntries2.add(ReleaseActivity.TASK_TITLE_UPDATED.create(timestamp, username, original.getType(), original.getId(), original.getTitle(), original.getTitle(), updated.getTitle()));
        }
        if (!Objects.equal((Object)original.getDescription(), (Object)updated.getDescription())) {
            logEntries2.add(ReleaseActivity.TASK_DESCRIPTION_UPDATED.create(timestamp, username, original.getType(), original.getId(), updated.getTitle(), original.getDescription(), updated.getDescription()));
        }
        if (!Objects.equal((Object)original.getOwner(), (Object)updated.getOwner())) {
            logEntries2.add(ReleaseActivity.TASK_OWNER_UPDATED.create(timestamp, username, original.getType(), original.getId(), updated.getTitle(), ReleaseActivityUserFormatter.quoteUser(original.getOwner(), this.userInfoResolver), ReleaseActivityUserFormatter.quoteUser(updated.getOwner(), this.userInfoResolver)));
        }
        if (!Objects.equal((Object)original.getTeam(), (Object)updated.getTeam())) {
            logEntries2.add(ReleaseActivity.TASK_TASK_TEAM_UPDATED.create(timestamp, username, original.getType(), original.getId(), updated.getTitle(), ReleaseActivityUserFormatter.quoteAssignee(original.getTeam()), ReleaseActivityUserFormatter.quoteAssignee(updated.getTeam())));
        }
        if (!Objects.equal((Object)original.getDueDate(), (Object)updated.getDueDate())) {
            logEntries2.add(ReleaseActivity.TASK_DUE_DATE_UPDATED.create(timestamp, username, original.getType(), original.getId(), updated.getTitle(), ReleaseActivityDateFormatter.formatDate(original.getDueDate()), ReleaseActivityDateFormatter.formatDate(updated.getDueDate())));
        }
        if (!Objects.equal((Object)original.getScheduledStartDate(), (Object)updated.getScheduledStartDate())) {
            logEntries2.add(ReleaseActivity.TASK_SCHEDULED_START_DATE_UPDATED.create(timestamp, username, original.getType(), original.getId(), updated.getTitle(), ReleaseActivityDateFormatter.formatDate(original.getScheduledStartDate()), ReleaseActivityDateFormatter.formatDate(updated.getScheduledStartDate())));
        }
        if (!Objects.equal((Object)original.isWaitForScheduledStartDate(), (Object)updated.isWaitForScheduledStartDate())) {
            logEntries2.add(ReleaseActivity.TASK_WAIT_FOR_SCHEDULED_START_DATE_UPDATED.create(timestamp, username, original.getType(), original.getId(), updated.getTitle(), updated.isWaitForScheduledStartDate()));
        }
        if (!Objects.equal((Object)original.getFlagStatus(), (Object)updated.getFlagStatus())) {
            logEntries2.add(ReleaseActivity.TASK_FLAG_STATUS_UPDATED.create(timestamp, username, original.getType(), original.getId(), updated.getTitle(), original.getFlagStatus().name(), updated.getFlagStatus().name()));
        }
        if (!Objects.equal((Object)original.getFlagComment(), (Object)updated.getFlagComment())) {
            logEntries2.add(ReleaseActivity.TASK_FLAG_COMMENT_UPDATED.create(timestamp, username, original.getType(), original.getId(), updated.getTitle(), original.getFlagComment(), updated.getFlagComment()));
        }
        if (!Objects.equal((Object)original.getPlannedDuration(), (Object)updated.getPlannedDuration())) {
            logEntries2.add(ReleaseActivity.TASK_DURATION_UPDATED.create(timestamp, username, original.getType(), original.getId(), updated.getTitle(), DurationFormatter.formatDuration(original.getPlannedDuration()), DurationFormatter.formatDuration(updated.getPlannedDuration())));
        }
        if (!Objects.equal((Object)original.getPrecondition(), (Object)updated.getPrecondition())) {
            logEntries2.add(ReleaseActivity.TASK_PRECONDITION_UPDATED.create(timestamp, username, original.getType(), original.getId(), updated.getTitle(), original.getPrecondition(), updated.getPrecondition()));
        }
        if (!Objects.equal((Object)original.isTaskFailureHandlerEnabled(), (Object)updated.isTaskFailureHandlerEnabled())) {
            logEntries2.add(ReleaseActivity.TASK_FAILURE_HANDLE_ENABLED.create(timestamp, username, original.getType(), original.getId(), updated.getTitle(), original.isTaskFailureHandlerEnabled(), updated.isTaskFailureHandlerEnabled()));
        }
        if (!Objects.equal((Object)original.getTaskRecoverOp(), (Object)updated.getTaskRecoverOp())) {
            logEntries2.add(ReleaseActivity.TASK_RECOVER_OP_UPDATED.create(timestamp, username, original.getType(), original.getId(), updated.getTitle(), original.getTaskRecoverOp(), updated.getTaskRecoverOp()));
        }
        if (!Objects.equal((Object)original.getFailureHandler(), (Object)updated.getFailureHandler())) {
            logEntries2.add(ReleaseActivity.TASK_RECOVER_SCRIPT_UPDATED.create(timestamp, username, original.getType(), original.getId(), updated.getTitle(), original.getFailureHandler(), updated.getFailureHandler()));
        }
        if (original.delayDuringBlackoutHasChanged(updated)) {
            logEntries2.add(ReleaseActivity.TASK_POSTPONE_BLACKOUT_UPDATED.create(timestamp, username, original.getType(), original.getId(), updated.getTitle(), original.isDelayDuringBlackout(), updated.isDelayDuringBlackout()));
        }
        if (!Objects.equal((Object)original.isCheckAttributes(), (Object)updated.isCheckAttributes())) {
            logEntries2.add(ReleaseActivity.TASK_CHECK_ATTRIBUTES_UPDATED.create(timestamp, username, original.getType(), original.getId(), updated.getTitle(), original.isCheckAttributes(), updated.isCheckAttributes()));
        }
        if (!Objects.equal(this.newArrayListOrNull(original.getTags()), (Object)updated.getTags())) {
            logEntries2.add(ReleaseActivity.TASK_TAGS_UPDATED.create(timestamp, username, original.getType(), original.getId(), updated.getTitle(), original.getTags(), updated.getTags() != null ? Sets.newHashSet((java.lang.Iterable)updated.getTags()) : null));
        }
        Diff watchersDiff = Diff.apply((Iterable)CollectionConverters.asScala((Set)original.getWatchers()).toIterable(), (Iterable)CollectionConverters.asScala((Set)updated.getWatchers()).toIterable());
        CollectionConverters.asJava((Iterable)watchersDiff.deletedValues()).forEach(removed -> logEntries2.add(ReleaseActivity.TASK_WATCHER_REMOVED.create(timestamp, username, original.getType(), original.getId(), removed, updated.getTitle())));
        CollectionConverters.asJava((Iterable)watchersDiff.newValues()).forEach(added -> logEntries2.add(ReleaseActivity.TASK_WATCHER_ADDED.create(timestamp, username, original.getType(), original.getId(), added, updated.getTitle())));
        return logEntries2;
    }

    private List<String> newArrayListOrNull(List<String> tags) {
        return tags != null ? Lists.newArrayList(tags) : null;
    }
}

