/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api.internal;

import com.xebialabs.deployit.plumbing.id.IdParam;
import com.xebialabs.xlrelease.api.internal.BaseActivityLogsResource;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.service.ReleaseActivityLogsService;
import com.xebialabs.xlrelease.views.ActivityLogEntryView;
import com.xebialabs.xlrelease.views.LogsFilters;
import com.xebialabs.xlrelease.views.converters.UserViewConverter;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Path(value="/activity")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Controller
public class ReleaseActivityLogsResource
extends BaseActivityLogsResource {
    private PermissionChecker permissions;

    @Autowired
    public ReleaseActivityLogsResource(ReleaseActivityLogsService releaseActivityLogsService, UserViewConverter userViewConverter, PermissionChecker permissions) {
        super(releaseActivityLogsService, userViewConverter);
        this.permissions = permissions;
    }

    @POST
    @Path(value="/{releaseId:.*Release[^/-]*}/logs/search")
    public List<ActivityLogEntryView> searchReleaseLogs(@PathParam(value="releaseId") @IdParam String releaseId, LogsFilters filters) {
        this.permissions.checkView(releaseId);
        return this.searchLogs(releaseId, filters);
    }
}

