/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.xebialabs.xlrelease.domain.ActivityLogEntry;
import com.xebialabs.xlrelease.service.UserInfoResolver;
import com.xebialabs.xlrelease.views.LogsFilters;
import java.util.Date;
import scala.Function1;
import scala.Serializable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.immutable.List;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001a4Qa\u0003\u0007\u0002\u0002UA\u0001\u0002\b\u0001\u0003\u0006\u0004%\t!\b\u0005\tE\u0001\u0011\t\u0011)A\u0005=!)1\u0005\u0001C\u0001I!)q\u0005\u0001C\u0001Q!)\u0011\t\u0001C\u0001\u0005\")\u0001\u000b\u0001C\u0001#\")Q\u000b\u0001C\u0001-\")A\u000e\u0001C\u0001[\")\u0011\u000f\u0001D\u0001e\")Q\u000f\u0001D\u0001m\n9\")Y:f\u0003\u000e$\u0018N^5us2{wm]*feZL7-\u001a\u0006\u0003\u001b9\tqa]3sm&\u001cWM\u0003\u0002\u0010!\u0005I\u0001\u0010\u001c:fY\u0016\f7/\u001a\u0006\u0003#I\t\u0011\u0002_3cS\u0006d\u0017MY:\u000b\u0003M\t1aY8n\u0007\u0001\u0019\"\u0001\u0001\f\u0011\u0005]QR\"\u0001\r\u000b\u0003e\tQa]2bY\u0006L!a\u0007\r\u0003\r\u0005s\u0017PU3g\u0003A)8/\u001a:J]\u001a|'+Z:pYZ,'/F\u0001\u001f!\ty\u0002%D\u0001\r\u0013\t\tCB\u0001\tVg\u0016\u0014\u0018J\u001c4p%\u0016\u001cx\u000e\u001c<fe\u0006\tRo]3s\u0013:4wNU3t_24XM\u001d\u0011\u0002\rqJg.\u001b;?)\t)c\u0005\u0005\u0002 \u0001!)Ad\u0001a\u0001=\u00059Q.\u0019;dQ\u0016\u001cHcA\u0015-iA\u0011qCK\u0005\u0003Wa\u0011qAQ8pY\u0016\fg\u000eC\u0003.\t\u0001\u0007a&\u0001\u0005m_\u001e,e\u000e\u001e:z!\ty#'D\u00011\u0015\t\td\"\u0001\u0004e_6\f\u0017N\\\u0005\u0003gA\u0012\u0001#Q2uSZLG/\u001f'pO\u0016sGO]=\t\u000bU\"\u0001\u0019\u0001\u001c\u0002\r\u0019LG\u000e^3s!\t9dH\u0004\u00029yA\u0011\u0011\bG\u0007\u0002u)\u00111\bF\u0001\u0007yI|w\u000e\u001e \n\u0005uB\u0012A\u0002)sK\u0012,g-\u0003\u0002@\u0001\n11\u000b\u001e:j]\u001eT!!\u0010\r\u0002\u000f\t,Go^3f]R!\u0011f\u0011#O\u0011\u0015iS\u00011\u0001/\u0011\u0015)U\u00011\u0001G\u0003\u00111'o\\7\u0011\u0005\u001dcU\"\u0001%\u000b\u0005%S\u0015\u0001B;uS2T\u0011aS\u0001\u0005U\u00064\u0018-\u0003\u0002N\u0011\n!A)\u0019;f\u0011\u0015yU\u00011\u0001G\u0003\t!x.\u0001\u0007xSRDG+\u0019:hKRLE\rF\u0002*%NCQ!\f\u0004A\u00029BQ\u0001\u0016\u0004A\u0002Y\n\u0001\u0002^1sO\u0016$\u0018\nZ\u0001\u000bM&dG/\u001a:M_\u001e\u001cHcA,[IB\u0019q\t\u0017\u0018\n\u0005eC%\u0001\u0002'jgRDQaW\u0004A\u0002q\u000bA\"Y2uSZLG/\u001f'pON\u00042!\u00182/\u001d\tq\u0006M\u0004\u0002:?&\t\u0011$\u0003\u0002b1\u00059\u0001/Y2lC\u001e,\u0017BA-d\u0015\t\t\u0007\u0004C\u0003f\u000f\u0001\u0007a-A\u0004gS2$XM]:\u0011\u0005\u001dTW\"\u00015\u000b\u0005%t\u0011!\u0002<jK^\u001c\u0018BA6i\u0005-aunZ:GS2$XM]:\u0002\u001f\u001d,GOR5mi\u0016\u0014X\r\u001a'pON$2a\u00168q\u0011\u0015y\u0007\u00021\u00017\u0003-\u0019wN\u001c;bS:,'/\u00133\t\u000b\u0015D\u0001\u0019\u00014\u0002\u001d]LG\u000f[\"bi\u0016<wN]5fgR\u0019\u0011f\u001d;\t\u000b5J\u0001\u0019\u0001\u0018\t\u000b\u0015L\u0001\u0019\u00014\u0002\u0013\u0019,Go\u00195M_\u001e\u001cHC\u0001/x\u0011\u0015y'\u00021\u00017\u0001")
public abstract class BaseActivityLogsService {
    private final UserInfoResolver userInfoResolver;

    public UserInfoResolver userInfoResolver() {
        return this.userInfoResolver;
    }

    public boolean matches(ActivityLogEntry logEntry, String filter) {
        return filter == null || BaseActivityLogsService.matches$1(logEntry.getMessage(), filter) || BaseActivityLogsService.matches$1(logEntry.getUsername(), filter) || BaseActivityLogsService.matches$1(this.userInfoResolver().getFullNameOf(logEntry.getUsername()), filter);
    }

    public boolean between(ActivityLogEntry logEntry, Date from, Date to) {
        boolean predicate = false;
        predicate = from == null && to == null ? true : (from == null ? logEntry.getEventTime().before(to) || logEntry.getEventTime().equals(to) : (to == null ? logEntry.getEventTime().after(from) || logEntry.getEventTime().equals(from) : !(!logEntry.getEventTime().after(from) && !logEntry.getEventTime().equals(from) || !logEntry.getEventTime().before(to) && !logEntry.getEventTime().equals(to))));
        return predicate;
    }

    /*
     * WARNING - void declaration
     */
    public boolean withTargetId(ActivityLogEntry logEntry, String targetId) {
        void var3_3;
        boolean predicate = false;
        if (targetId == null) {
            predicate = true;
        } else {
            String string = logEntry.getTargetId();
            String string2 = targetId;
            predicate = !(string != null ? !string.equals(string2) : string2 != null);
        }
        return (boolean)var3_3;
    }

    public java.util.List<ActivityLogEntry> filterLogs(List<ActivityLogEntry> activityLogs, LogsFilters filters) {
        Ordering sortOrder = filters.isDateAsc() ? package$.MODULE$.Ordering().comparatorToOrdering(ActivityLogEntry.BY_EVENT_TIME) : package$.MODULE$.Ordering().comparatorToOrdering(ActivityLogEntry.BY_EVENT_TIME).reverse();
        return (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((SeqLike)((TraversableLike)((TraversableLike)((TraversableLike)activityLogs.filter((Function1 & java.io.Serializable & Serializable)logEntry -> BoxesRunTime.boxToBoolean((boolean)this.matches(logEntry, filters.getFilter())))).filter((Function1 & java.io.Serializable & Serializable)logEntry -> BoxesRunTime.boxToBoolean((boolean)this.between(logEntry, filters.getFrom(), filters.getTo())))).filter((Function1 & java.io.Serializable & Serializable)logEntry -> BoxesRunTime.boxToBoolean((boolean)this.withCategories(logEntry, filters)))).filter((Function1 & java.io.Serializable & Serializable)logEntry -> BoxesRunTime.boxToBoolean((boolean)this.withTargetId(logEntry, filters.getTargetId())))).sorted(sortOrder)).asJava();
    }

    public java.util.List<ActivityLogEntry> getFilteredLogs(String containerId, LogsFilters filters) {
        List<ActivityLogEntry> activityLogs = this.fetchLogs(containerId);
        return this.filterLogs(activityLogs, filters);
    }

    public abstract boolean withCategories(ActivityLogEntry var1, LogsFilters var2);

    public abstract List<ActivityLogEntry> fetchLogs(String var1);

    private static final boolean matches$1(String text, String filter$1) {
        return text != null && text.toLowerCase().contains(filter$1.toLowerCase());
    }

    public BaseActivityLogsService(UserInfoResolver userInfoResolver) {
        this.userInfoResolver = userInfoResolver;
    }
}

