/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.activity;

import com.google.common.base.Joiner;
import com.google.common.collect.Multimap;
import com.google.common.collect.TreeMultimap;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.xlrelease.domain.ActivityLogEntry;
import com.xebialabs.xlrelease.domain.ReleaseActivity;
import com.xebialabs.xlrelease.domain.Team;
import java.util.Date;
import java.util.List;

public class PermissionsLogFormatter {
    private Date timestamp;
    private String username;
    private Type targetType;
    private String targetId;
    private Multimap<String, String> teamToPermissions = TreeMultimap.create();
    private static final Joiner.MapJoiner WITH_ARROWS = Joiner.on((String)"\n").withKeyValueSeparator(" => ");

    public PermissionsLogFormatter(Date timestamp, String username, Type targetType, String targetId, List<Team> teams) {
        this.timestamp = timestamp;
        this.username = username;
        this.targetType = targetType;
        this.targetId = targetId;
        for (Team team : teams) {
            this.teamToPermissions.putAll((Object)team.getTeamName(), (Iterable)team.getPermissions());
        }
    }

    public ActivityLogEntry getLogEntry() {
        String text = WITH_ARROWS.join(this.teamToPermissions.asMap().entrySet());
        return ReleaseActivity.PERMISSIONS_UPDATED.create(this.timestamp, this.username, this.targetType, this.targetId, text);
    }
}

