/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.ascode.service;

import com.xebialabs.ascode.exception.AsCodeException;
import com.xebialabs.ascode.exception.AsCodeException$;
import com.xebialabs.ascode.yaml.dto.AsCodeResponse;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.xlplatform.coc.dto.SCMTraceabilityData;
import com.xebialabs.xlrelease.ascode.service.CreateReleaseTaskContext;
import com.xebialabs.xlrelease.ascode.service.CreateReleaseTaskSnapshot;
import com.xebialabs.xlrelease.ascode.service.DashboardAsCodeService;
import com.xebialabs.xlrelease.ascode.service.ImportResult;
import com.xebialabs.xlrelease.ascode.service.PostCommitAction;
import com.xebialabs.xlrelease.ascode.service.ReferenceSolver;
import com.xebialabs.xlrelease.ascode.utils.DateUtils$;
import com.xebialabs.xlrelease.ascode.utils.ImportContext;
import com.xebialabs.xlrelease.ascode.utils.ImportContext$;
import com.xebialabs.xlrelease.ascode.utils.ImportScope;
import com.xebialabs.xlrelease.ascode.utils.TemplateScope;
import com.xebialabs.xlrelease.ascode.utils.TemplateUtils$;
import com.xebialabs.xlrelease.ascode.utils.Utils$;
import com.xebialabs.xlrelease.domain.CreateReleaseTask;
import com.xebialabs.xlrelease.domain.CustomScriptTask;
import com.xebialabs.xlrelease.domain.Dependency;
import com.xebialabs.xlrelease.domain.GateTask;
import com.xebialabs.xlrelease.domain.Link;
import com.xebialabs.xlrelease.domain.ParallelGroup;
import com.xebialabs.xlrelease.domain.Phase;
import com.xebialabs.xlrelease.domain.PythonScript;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.ReleaseExtension;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.TaskContainer;
import com.xebialabs.xlrelease.domain.TaskGroup;
import com.xebialabs.xlrelease.domain.UserInputTask;
import com.xebialabs.xlrelease.domain.VisitableItem;
import com.xebialabs.xlrelease.domain.events.CreatedFromAsCode;
import com.xebialabs.xlrelease.domain.events.ReleaseCreatedEvent;
import com.xebialabs.xlrelease.domain.events.ReleaseCreationSource;
import com.xebialabs.xlrelease.domain.events.ReleaseUpdatedFromAsCodeEvent;
import com.xebialabs.xlrelease.domain.events.TemplateVariablesChangedEvent;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.domain.facet.Facet;
import com.xebialabs.xlrelease.domain.folder.Folder;
import com.xebialabs.xlrelease.domain.status.PhaseStatus;
import com.xebialabs.xlrelease.domain.status.ReleaseStatus;
import com.xebialabs.xlrelease.domain.status.TaskStatus;
import com.xebialabs.xlrelease.domain.variables.Variable;
import com.xebialabs.xlrelease.domain.versioning.ascode.validation.ValidationMessage;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.plugins.dashboard.domain.Dashboard;
import com.xebialabs.xlrelease.repository.CiCloneHelper;
import com.xebialabs.xlrelease.repository.FacetRepositoryDispatcher;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.serialization.json.repository.ResolveOptions$;
import com.xebialabs.xlrelease.service.CiIdService;
import com.xebialabs.xlrelease.service.FacetService;
import com.xebialabs.xlrelease.service.FolderService;
import com.xebialabs.xlrelease.service.ReleaseService;
import com.xebialabs.xlrelease.variable.VariableHelper$;
import com.xebialabs.xlrelease.variable.VariablePersistenceHelper$;
import com.xebialabs.xlrelease.versioning.ascode.ImportValidator;
import com.xebialabs.xltype.serialization.CiReference;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.Date;
import java.util.Map;
import org.joda.time.DateTime;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.ListMap;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Try$;

@Service
@ScalaSignature(bytes="\u0006\u0005\r]c\u0001\u0002\u0013&\u0001AB\u0001b\u0010\u0001\u0003\u0002\u0003\u0006I\u0001\u0011\u0005\t\u000b\u0002\u0011\t\u0011)A\u0005\r\"A!\n\u0001B\u0001B\u0003%1\n\u0003\u0005O\u0001\t\u0005\t\u0015!\u0003P\u0011!)\u0006A!A!\u0002\u00131\u0006\u0002C-\u0001\u0005\u0003\u0005\u000b\u0011\u0002.\t\u0011\u0001\u0004!\u0011!Q\u0001\n\u0005D\u0001\u0002\u001a\u0001\u0003\u0002\u0003\u0006I!\u001a\u0005\tQ\u0002\u0011\t\u0011)A\u0005S\")A\u000e\u0001C\u0001[\"9\u0011q\u0002\u0001\u0005\u0002\u0005E\u0001bBA\u001d\u0001\u0011\u0005\u00111\b\u0005\b\u0003\u0017\u0003A\u0011BAG\u0011\u001d\t9\n\u0001C\u0005\u00033Cq!!*\u0001\t\u0013\t9\u000bC\u0004\u00022\u0002!I!a-\t\u000f\u0005E\u0007\u0001\"\u0003\u0002T\"9\u0011q\u001d\u0001\u0005\n\u0005%\bbBAw\u0001\u0011%\u0011q\u001e\u0005\b\u0003w\u0004A\u0011BA\u007f\u0011\u001d\u0011\t\u0001\u0001C\u0005\u0005\u0007AqAa\u0004\u0001\t\u0013\u0011\t\u0002C\u0004\u0003$\u0001!IA!\n\t\u000f\t-\u0002\u0001\"\u0003\u0003.!9!q\u0007\u0001\u0005\n\te\u0002b\u0002B*\u0001\u0011%!Q\u000b\u0005\b\u0005\u0013\u0003A\u0011\u0001BF\u0011\u001d\u0011\u0019\n\u0001C\u0005\u0005+CqAa,\u0001\t\u0013\u0011\t\fC\u0004\u0003N\u0002!IAa4\t\u000f\tM\b\u0001\"\u0003\u0003v\"9!q \u0001\u0005\n\r\u0005\u0001bBB\u0004\u0001\u0011%1\u0011\u0002\u0005\b\u0007'\u0001A\u0011BB\u000b\u0011\u001d\u0019I\u0003\u0001C\u0005\u0007W\u0011Q\u0003V3na2\fG/Z!t\u0007>$WmU3sm&\u001cWM\u0003\u0002'O\u000591/\u001a:wS\u000e,'B\u0001\u0015*\u0003\u0019\t7oY8eK*\u0011!fK\u0001\nq2\u0014X\r\\3bg\u0016T!\u0001L\u0017\u0002\u0013a,'-[1mC\n\u001c(\"\u0001\u0018\u0002\u0007\r|Wn\u0001\u0001\u0014\u0007\u0001\tt\u0007\u0005\u00023k5\t1GC\u00015\u0003\u0015\u00198-\u00197b\u0013\t14G\u0001\u0004B]f\u0014VM\u001a\t\u0003quj\u0011!\u000f\u0006\u0003um\nQa\u001d7gi)T\u0011\u0001P\u0001\tOJL'P\u001f7fI&\u0011a(\u000f\u0002\b\u0019><w-\u001b8h\u00039\u0011X\r\\3bg\u0016\u001cVM\u001d<jG\u0016\u0004\"!Q\"\u000e\u0003\tS!AJ\u0015\n\u0005\u0011\u0013%A\u0004*fY\u0016\f7/Z*feZL7-Z\u0001\u0017I\u0006\u001c\bNY8be\u0012\f5oQ8eKN+'O^5dKB\u0011q\tS\u0007\u0002K%\u0011\u0011*\n\u0002\u0017\t\u0006\u001c\bNY8be\u0012\f5oQ8eKN+'O^5dK\u0006y!/\u001a4fe\u0016t7-Z*pYZ,'\u000f\u0005\u0002H\u0019&\u0011Q*\n\u0002\u0010%\u00164WM]3oG\u0016\u001cv\u000e\u001c<fe\u0006\t\"/\u001a7fCN,'+\u001a9pg&$xN]=\u0011\u0005A\u001bV\"A)\u000b\u0005IK\u0013A\u0003:fa>\u001c\u0018\u000e^8ss&\u0011A+\u0015\u0002\u0012%\u0016dW-Y:f%\u0016\u0004xn]5u_JL\u0018aC2j\u0013\u0012\u001cVM\u001d<jG\u0016\u0004\"!Q,\n\u0005a\u0013%aC\"j\u0013\u0012\u001cVM\u001d<jG\u0016\f\u0001\"\u001a<f]R\u0014Uo\u001d\t\u00037zk\u0011\u0001\u0018\u0006\u0003;&\na!\u001a<f]R\u001c\u0018BA0]\u0005EAFJU3mK\u0006\u001cX-\u0012<f]R\u0014Uo]\u0001\u001aM\u0006\u001cW\r\u001e*fa>\u001c\u0018\u000e^8ss\u0012K7\u000f]1uG\",'\u000f\u0005\u0002QE&\u00111-\u0015\u0002\u001a\r\u0006\u001cW\r\u001e*fa>\u001c\u0018\u000e^8ss\u0012K7\u000f]1uG\",'/\u0001\u0007gC\u000e,GoU3sm&\u001cW\r\u0005\u0002BM&\u0011qM\u0011\u0002\r\r\u0006\u001cW\r^*feZL7-Z\u0001\u000eM>dG-\u001a:TKJ4\u0018nY3\u0011\u0005\u0005S\u0017BA6C\u000551u\u000e\u001c3feN+'O^5dK\u00061A(\u001b8jiz\"\"B\\8qcJ\u001cH/\u001e<x!\t9\u0005\u0001C\u0003@\u0015\u0001\u0007\u0001\tC\u0003F\u0015\u0001\u0007a\tC\u0003K\u0015\u0001\u00071\nC\u0003O\u0015\u0001\u0007q\nC\u0003V\u0015\u0001\u0007a\u000bC\u0003Z\u0015\u0001\u0007!\fC\u0003a\u0015\u0001\u0007\u0011\rC\u0003e\u0015\u0001\u0007Q\rC\u0003i\u0015\u0001\u0007\u0011\u000e\u000b\u0002\u000bsB\u0019!0a\u0003\u000e\u0003mT!\u0001`?\u0002\u0015\u0005tgn\u001c;bi&|gN\u0003\u0002\u007f\u007f\u00069a-Y2u_JL(\u0002BA\u0001\u0003\u0007\tQAY3b]NTA!!\u0002\u0002\b\u0005y1\u000f\u001d:j]\u001e4'/Y7fo>\u00148N\u0003\u0002\u0002\n\u0005\u0019qN]4\n\u0007\u000551PA\u0005BkR|w/\u001b:fI\u00069\u0001O]8dKN\u001cHCBA\n\u00033\tI\u0003E\u0002H\u0003+I1!a\u0006&\u00051IU\u000e]8siJ+7/\u001e7u\u0011\u001d\tYb\u0003a\u0001\u0003;\tqaY8oi\u0016DH\u000f\u0005\u0003\u0002 \u0005\u0015RBAA\u0011\u0015\r\t\u0019cJ\u0001\u0006kRLGn]\u0005\u0005\u0003O\t\tCA\u0007J[B|'\u000f^\"p]R,\u0007\u0010\u001e\u0005\b\u0003WY\u0001\u0019AA\u0017\u0003!!X-\u001c9mCR,\u0007\u0003BA\u0018\u0003ki!!!\r\u000b\u0007\u0005M\u0012&\u0001\u0004e_6\f\u0017N\\\u0005\u0005\u0003o\t\tDA\u0004SK2,\u0017m]3\u00021\u0019Lg\u000eZ(s!J,G-[2u)\u0016l\u0007\u000f\\1uK&#7\u000f\u0006\u0003\u0002>\u0005}\u0003\u0003CA \u0003\u001b\n\u0019&!\u0017\u000f\t\u0005\u0005\u0013\u0011\n\t\u0004\u0003\u0007\u001aTBAA#\u0015\r\t9eL\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005-3'\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003\u001f\n\tFA\u0002NCBT1!a\u00134!\u0011\ty$!\u0016\n\t\u0005]\u0013\u0011\u000b\u0002\u0007'R\u0014\u0018N\\4\u0011\u000fI\nY&a\u0015\u0002.%\u0019\u0011QL\u001a\u0003\rQ+\b\u000f\\33\u0011\u001d\t\t\u0007\u0004a\u0001\u0003G\nA\"\u00197m)\u0016l\u0007\u000f\\1uKN\u0004\u0002\"!\u001a\u0002p\u0005M\u0014\u0011P\u0007\u0003\u0003ORA!!\u001b\u0002l\u0005I\u0011.\\7vi\u0006\u0014G.\u001a\u0006\u0004\u0003[\u001a\u0014AC2pY2,7\r^5p]&!\u0011\u0011OA4\u0005\u001da\u0015n\u001d;NCB\u0004B!a\b\u0002v%!\u0011qOA\u0011\u0005-IU\u000e]8siN\u001bw\u000e]3\u0011\r\u0005m\u0014QQA\u0017\u001d\u0011\ti(!!\u000f\t\u0005\r\u0013qP\u0005\u0002i%\u0019\u00111Q\u001a\u0002\u000fA\f7m[1hK&!\u0011qQAE\u0005\u0011a\u0015n\u001d;\u000b\u0007\u0005\r5'\u0001\u000buK6\u0004H.\u0019;f\u0003\n\u001cx\u000e\\;uKB\u000bG\u000f\u001b\u000b\u0007\u0003'\ny)a%\t\u000f\u0005EU\u00021\u0001\u0002t\u0005)1oY8qK\"9\u0011QS\u0007A\u0002\u0005M\u0013!\u0002;ji2,\u0017\u0001\u00024j]\u0012$b!a'\u0002\"\u0006\r\u0006#\u0002\u001a\u0002\u001e\u00065\u0012bAAPg\t1q\n\u001d;j_:Dq!a\u0007\u000f\u0001\u0004\ti\u0002C\u0004\u0002,9\u0001\r!!\f\u0002\r\r\u0014X-\u0019;f)!\t\u0019\"!+\u0002,\u00065\u0006bBA\u000e\u001f\u0001\u0007\u0011Q\u0004\u0005\b\u0003Wy\u0001\u0019AA\u0017\u0011\u001d\tyk\u0004a\u0001\u0003'\n!!\u001b3\u0002\u001bA\u0014xnY3tg\u001a\u000b7-\u001a;t)\u0011\t),a/\u0011\u0007I\n9,C\u0002\u0002:N\u0012A!\u00168ji\"9\u0011Q\u0018\tA\u0002\u0005}\u0016A\u00024bG\u0016$8\u000f\u0005\u0004\u0002|\u0005\u0005\u0017QY\u0005\u0005\u0003\u0007\fIIA\u0002TKF\u0004B!a2\u0002N6\u0011\u0011\u0011\u001a\u0006\u0005\u0003\u0017\f\t$A\u0003gC\u000e,G/\u0003\u0003\u0002P\u0006%'!\u0002$bG\u0016$\u0018\u0001\u00044pY\u0012,'/\u0012=jgR\u001cH\u0003BAk\u0003G\u0004RAMAO\u0003/\u0004B!!7\u0002`6\u0011\u00111\u001c\u0006\u0005\u0003;\f\t$\u0001\u0004g_2$WM]\u0005\u0005\u0003C\fYN\u0001\u0004G_2$WM\u001d\u0005\b\u0003K\f\u0002\u0019AA*\u0003\u0011\u0001\u0018\r\u001e5\u00029M,GOV1mS\u00124u\u000e\u001c3fe\u0006sG\rV3na2\fG/Z%egR!\u0011QWAv\u0011\u001d\tYC\u0005a\u0001\u0003[\t\u0011D^1mS\u0012\fG/Z!oIV\u0003H-\u0019;f\r>dG-\u001a:JIR!\u0011QWAy\u0011\u001d\t\u0019p\u0005a\u0001\u0003k\fA\u0001^1tWB!\u0011qFA|\u0013\u0011\tI0!\r\u0003#\r\u0013X-\u0019;f%\u0016dW-Y:f)\u0006\u001c8.A\u000ewC2LG-\u0019;f\u0003:$W\u000b\u001d3bi\u0016$V-\u001c9mCR,\u0017\n\u001a\u000b\u0005\u0003k\u000by\u0010C\u0004\u0002tR\u0001\r!!>\u0002+%t\u0017\u000e^5bY&TXm\u0011*U\u0007>tG/\u001a=ugR!!Q\u0001B\u0007!\u0019\tY(!\"\u0003\bA\u0019qI!\u0003\n\u0007\t-QE\u0001\rDe\u0016\fG/\u001a*fY\u0016\f7/\u001a+bg.\u001cuN\u001c;fqRDq!a\u000b\u0016\u0001\u0004\ti#\u0001\fsKN,G\u000fV3na2\fG/Z\"S)\u001aKW\r\u001c3t)!\t)La\u0005\u0003\u0016\te\u0001bBA\u0016-\u0001\u0007\u0011Q\u0006\u0005\b\u0005/1\u0002\u0019\u0001B\u0003\u0003-)\b\u000fZ1uK\u0012\u001c%\u000bV:\t\u000f\tma\u00031\u0001\u0003\u001e\u0005\u0019\"/\u001a;ve:Le.\u001b;jC24\u0015.\u001a7egB\u0019!Ga\b\n\u0007\t\u00052GA\u0004C_>dW-\u00198\u00021U\u0004H-\u0019;f\u0007J,\u0017\r^3SK2,\u0017m]3UCN\\7\u000f\u0006\u0004\u00026\n\u001d\"\u0011\u0006\u0005\b\u0003W9\u0002\u0019AA\u0017\u0011\u001d\u00119b\u0006a\u0001\u0005\u000b\ta!\u001e9eCR,G\u0003CA\n\u0005_\u0011\tD!\u000e\t\u000f\u0005m\u0001\u00041\u0001\u0002\u001e!9!1\u0007\rA\u0002\u00055\u0012\u0001C3ySN$\u0018N\\4\t\u000f\u0005-\u0002\u00041\u0001\u0002.\u0005Aa/\u00197jI\u0006$X\r\u0006\u0004\u0003<\t=#\u0011\u000b\t\u0007\u0003w\n)I!\u0010\u0011\t\t}\"1J\u0007\u0003\u0005\u0003RAAa\u0011\u0003F\u0005Qa/\u00197jI\u0006$\u0018n\u001c8\u000b\u0007!\u00129E\u0003\u0003\u0003J\u0005E\u0012A\u0003<feNLwN\\5oO&!!Q\nB!\u0005E1\u0016\r\\5eCRLwN\\'fgN\fw-\u001a\u0005\b\u00037I\u0002\u0019AA\u000f\u0011\u001d\tY#\u0007a\u0001\u0003[\t!bZ3oKJ\fG/Z%e+\u0011\u00119F!\u0019\u0015\r\u0005M#\u0011\fBC\u0011\u001d\u0011YF\u0007a\u0001\u0005;\n!aY5\u0011\t\t}#\u0011\r\u0007\u0001\t\u001d\u0011\u0019G\u0007b\u0001\u0005K\u0012\u0011\u0001V\t\u0005\u0005O\u0012i\u0007E\u00023\u0005SJ1Aa\u001b4\u0005\u001dqu\u000e\u001e5j]\u001e\u0004BAa\u001c\u0003\u00026\u0011!\u0011\u000f\u0006\u0005\u0005g\u0012)(A\u0002vI6TAAa\u001e\u0003z\u0005\u0019\u0011\r]5\u000b\t\tm$QP\u0001\u0007a2,x-\u001b8\u000b\u0007\t}4&\u0001\u0005eKBdw._5u\u0013\u0011\u0011\u0019I!\u001d\u0003#\r{gNZ5hkJ\fG/[8o\u0013R,W\u000eC\u0004\u0003\bj\u0001\r!a\u0015\u0002\u0011A\f'/\u001a8u\u0013\u0012\fA\u0003]8qk2\fG/\u001a+f[Bd\u0017\r^3ECR\fG\u0003CA[\u0005\u001b\u0013yI!%\t\u000f\u0005m1\u00041\u0001\u0002\u001e!9\u00111F\u000eA\u0002\u00055\u0002bBAX7\u0001\u0007\u00111K\u0001\u0012a>\u0004X\u000f\\1uKBC\u0017m]3ECR\fG\u0003DA[\u0005/\u0013\tKa)\u0003(\n5\u0006b\u0002BM9\u0001\u0007!1T\u0001\u0006a\"\f7/\u001a\t\u0005\u0003_\u0011i*\u0003\u0003\u0003 \u0006E\"!\u0002)iCN,\u0007bBA\u00169\u0001\u0007\u0011Q\u0006\u0005\b\u0005Kc\u0002\u0019AA*\u0003!1w\u000e\u001c3fe&#\u0007b\u0002BU9\u0001\u0007!1V\u0001\u0005Q>lW\rE\u00033\u0003;\u000b\u0019\u0006C\u0004\u0002\u001cq\u0001\r!!\b\u0002!A|\u0007/\u001e7bi\u0016$\u0016m]6ECR\fGCDA[\u0005g\u0013YL!2\u0003H\n%'1\u001a\u0005\b\u0003gl\u0002\u0019\u0001B[!\u0011\tyCa.\n\t\te\u0016\u0011\u0007\u0002\u0005)\u0006\u001c8\u000eC\u0004\u0003>v\u0001\rAa0\u0002\u0013\r|g\u000e^1j]\u0016\u0014\b\u0003BA\u0018\u0005\u0003LAAa1\u00022\tiA+Y:l\u0007>tG/Y5oKJDq!a\u000b\u001e\u0001\u0004\ti\u0003C\u0004\u0003&v\u0001\r!a\u0015\t\u000f\t%V\u00041\u0001\u0003,\"9\u00111D\u000fA\u0002\u0005u\u0011!\u00069paVd\u0017\r^3Vg\u0016\u0014\u0018J\u001c9viR\u000b7o\u001b\u000b\u0007\u0003k\u0013\tN!7\t\u000f\u0005Mh\u00041\u0001\u0003TB!\u0011q\u0006Bk\u0013\u0011\u00119.!\r\u0003\u001bU\u001bXM]%oaV$H+Y:l\u0011\u001d\u0011YN\ba\u0001\u0005;\f\u0011B^1sS\u0006\u0014G.Z:\u0011\r\t}'Q\u001dBu\u001b\t\u0011\tO\u0003\u0003\u0003d\u0006-\u0014aB7vi\u0006\u0014G.Z\u0005\u0005\u0005O\u0014\tO\u0001\u0004Ck\u001a4WM\u001d\t\u0005\u0005W\u0014y/\u0004\u0002\u0003n*!!1\\A\u0019\u0013\u0011\u0011\tP!<\u0003\u0011Y\u000b'/[1cY\u0016\f\u0001\u0004]8qk2\fG/Z\"vgR|WnU2sSB$H+Y:l)\u0011\t)La>\t\u000f\u0005Mx\u00041\u0001\u0003zB!\u0011q\u0006B~\u0013\u0011\u0011i0!\r\u0003!\r+8\u000f^8n'\u000e\u0014\u0018\u000e\u001d;UCN\\\u0017!\u00079paVd\u0017\r^3De\u0016\fG/\u001a*fY\u0016\f7/\u001a+bg.$b!!.\u0004\u0004\r\u0015\u0001bBAzA\u0001\u0007\u0011Q\u001f\u0005\b\u00037\u0001\u0003\u0019AA\u000f\u0003A\u0001x\u000e];mCR,w)\u0019;f)\u0006\u001c8\u000e\u0006\u0003\u00026\u000e-\u0001bBAzC\u0001\u00071Q\u0002\t\u0005\u0003_\u0019y!\u0003\u0003\u0004\u0012\u0005E\"\u0001C$bi\u0016$\u0016m]6\u0002#A|\u0007/\u001e7bi\u0016$\u0016m]6He>,\b\u000f\u0006\u0007\u00026\u000e]1\u0011EB\u0012\u0007K\u00199\u0003C\u0004\u0004\u001a\t\u0002\raa\u0007\u0002\u000b\u001d\u0014x.\u001e9\u0011\t\u0005=2QD\u0005\u0005\u0007?\t\tDA\u0005UCN\\wI]8va\"9\u00111\u0006\u0012A\u0002\u00055\u0002b\u0002BSE\u0001\u0007\u00111\u000b\u0005\b\u0005S\u0013\u0003\u0019\u0001BV\u0011\u001d\tYB\ta\u0001\u0003;\ta\u0002\u001d:pG\u0016\u001c8oU2n\t\u0006$\u0018\r\u0006\u0004\u00026\u000e52q\t\u0005\b\u0007_\u0019\u0003\u0019AB\u0019\u0003\u0011!\u0017\r^1\u0011\u000bI\nija\r\u0011\t\rU21I\u0007\u0003\u0007oQAa!\u000f\u0004<\u0005\u0019A\r^8\u000b\t\ru2qH\u0001\u0004G>\u001c'bAB!W\u0005Q\u0001\u0010\u001c9mCR4wN]7\n\t\r\u00153q\u0007\u0002\u0014'\u000ekEK]1dK\u0006\u0014\u0017\u000e\\5us\u0012\u000bG/\u0019\u0005\b\u0003W\u0019\u0003\u0019AA\u0017Q\r\u000111\n\t\u0005\u0007\u001b\u001a\u0019&\u0004\u0002\u0004P)!1\u0011KA\u0002\u0003)\u0019H/\u001a:f_RL\b/Z\u0005\u0005\u0007+\u001ayEA\u0004TKJ4\u0018nY3")
public class TemplateAsCodeService
implements Logging {
    private final ReleaseService releaseService;
    private final DashboardAsCodeService dashboardAsCodeService;
    private final ReferenceSolver referenceSolver;
    private final ReleaseRepository releaseRepository;
    private final CiIdService ciIdService;
    private final XLReleaseEventBus eventBus;
    private final FacetRepositoryDispatcher facetRepositoryDispatcher;
    private final FacetService facetService;
    private final FolderService folderService;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        TemplateAsCodeService templateAsCodeService = this;
        synchronized (templateAsCodeService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public ImportResult process(ImportContext context, Release template) {
        this.logger().debug((Function0 & Serializable)() -> "Processing template: " + template.toString() + " with metadata " + context.metadata().toString());
        if (!template.getReleaseTriggers().isEmpty()) {
            throw new AsCodeException("Templates with release triggers are no longer supported.", AsCodeException$.MODULE$.$lessinit$greater$default$2());
        }
        this.referenceSolver.resolveReferences((ConfigurationItem)template, context.references(), (String)context.scope().getFolderId().orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()));
        Option<Release> option = this.find(context, template);
        if (option instanceof Some) {
            Some some = (Some)option;
            Release existing = (Release)some.value();
            this.logger().debug((Function0 & Serializable)() -> "Updating template: " + existing.toString());
            return this.update(context, existing, template);
        }
        if (None$.MODULE$.equals(option)) {
            this.logger().debug((Function0 & Serializable)() -> "Creating template: " + template.toString());
            String id = (String)context.templateIds().view().mapValues((Function1 & Serializable)x$1 -> (String)x$1._1()).getOrElse((Object)this.templateAbsolutePath(context.scope(), template.getTitle()), (Function0 & Serializable)() -> this.generateId(template, (String)context.scope().getFolderId().getOrElse((Function0 & Serializable)() -> Ids.ROOT_FOLDER_ID)));
            return this.create(context, template, id);
        }
        throw new MatchError(option);
    }

    public scala.collection.immutable.Map<String, Tuple2<String, Release>> findOrPredictTemplateIds(ListMap<ImportScope, List<Release>> allTemplates) {
        return (scala.collection.immutable.Map)allTemplates.toList().foldLeft((Object)Predef$.MODULE$.Map().empty(), (Function2 & Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 != null) {
                scala.collection.immutable.Map map = (scala.collection.immutable.Map)tuple2._1();
                Tuple2 tuple22 = (Tuple2)tuple2._2();
                if (tuple22 != null) {
                    ImportScope scope = (ImportScope)tuple22._1();
                    List templates = (List)tuple22._2();
                    ImportContext context = new ImportContext(scope, (scala.collection.immutable.Map<String, String>)Predef$.MODULE$.Map().empty(), (List<CiReference>)package$.MODULE$.List().empty(), (Option<SCMTraceabilityData>)None$.MODULE$, ImportContext$.MODULE$.apply$default$5(), ImportContext$.MODULE$.apply$default$6());
                    return (scala.collection.immutable.Map)map.$plus$plus((IterableOnce)templates.foldLeft((Object)Predef$.MODULE$.Map().empty(), (Function2 & Serializable)(x0$2, x1$2) -> {
                        Tuple2 tuple2 = new Tuple2(x0$2, x1$2);
                        if (tuple2 != null) {
                            String string;
                            scala.collection.immutable.Map idMap = (scala.collection.immutable.Map)tuple2._1();
                            Release template = (Release)tuple2._2();
                            Option<Release> option = this.find(context, template);
                            if (None$.MODULE$.equals(option)) {
                                string = this.generateId(template, (String)scope.getFolderId().getOrElse((Function0 & Serializable)() -> Ids.ROOT_FOLDER_ID));
                            } else if (option instanceof Some) {
                                Some some = (Some)option;
                                Release existing = (Release)some.value();
                                string = existing.getId();
                            } else {
                                throw new MatchError(option);
                            }
                            String id = string;
                            return (scala.collection.immutable.Map)idMap.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.templateAbsolutePath(scope, template.getTitle())), (Object)new Tuple2((Object)id, (Object)template)));
                        }
                        throw new MatchError((Object)tuple2);
                    }));
                }
            }
            throw new MatchError((Object)tuple2);
        });
    }

    private String templateAbsolutePath(ImportScope scope, String title) {
        Option<String> option = scope.getFolderPath();
        if (None$.MODULE$.equals(option)) {
            return title;
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            String path = (String)some.value();
            return Utils$.MODULE$.joinPaths((Seq<String>)new .colon.colon((Object)path, (List)new .colon.colon((Object)title, (List)Nil$.MODULE$)));
        }
        throw new MatchError(option);
    }

    private Option<Release> find(ImportContext context, Release template) {
        List matches = CollectionConverters$.MODULE$.ListHasAsScala(this.releaseService.findTemplatesByTitle((String)context.scope().getFolderId().getOrElse((Function0 & Serializable)() -> "/"), template.getTitle(), 0, 2, 1)).asScala().toList();
        if (matches.length() > 1) {
            this.logger().debug((Function0 & Serializable)() -> "There are multiple templates named [" + template.getTitle() + "] " + context.scope().description() + ", those are: " + matches.toString());
            throw new AsCodeException("Multiple templates are named [" + template.getTitle() + "] " + context.scope().description() + ". Can not determine which one to update.", AsCodeException$.MODULE$.$lessinit$greater$default$2());
        }
        return matches.headOption();
    }

    private ImportResult create(ImportContext context, Release template, String id) {
        this.populateTemplateData(context, template, id);
        List<ValidationMessage> messages = this.validate(context, template);
        Release created = this.releaseRepository.create(template, null);
        this.processScmData(context.scmData(), created);
        return new ImportResult((List<AsCodeResponse.ChangedIds>)new .colon.colon((Object)AsCodeResponse.EntityKinds$.MODULE$.ExtendedString(AsCodeResponse.EntityKinds$.MODULE$.CI()).ids().withCreated(created.getId()), (List)Nil$.MODULE$), (Seq<PostCommitAction>)new .colon.colon(() -> $this.eventBus.publish((XLReleaseEvent)new ReleaseCreatedEvent(created, (ReleaseCreationSource)new CreatedFromAsCode(context.scmData()))), (List)Nil$.MODULE$), (scala.collection.immutable.Map<String, scala.collection.immutable.Map<Type, AsCodeResponse.ChangedIds>>)Predef$.MODULE$.Map().empty(), messages);
    }

    private void processFacets(Seq<Facet> facets) {
        facets.foreach((Function1 & Serializable)facet -> {
            $this.facetService.validate(facet);
            return $this.facetRepositoryDispatcher.create(facet);
        });
    }

    private Option<Folder> folderExists(String path) {
        return Try$.MODULE$.apply((Function0 & Serializable)() -> $this.folderService.findByPath(path, path.split("/").length - 1)).toOption();
    }

    private void setValidFolderAndTemplateIds(Release template) {
        TemplateUtils$.MODULE$.forEachCreateReleaseTask(template, (Function1<CreateReleaseTask, BoxedUnit>)(Function1 & Serializable)task -> {
            TemplateAsCodeService.$anonfun$setValidFolderAndTemplateIds$1(this, task);
            return BoxedUnit.UNIT;
        });
    }

    private void validateAndUpdateFolderId(CreateReleaseTask task) {
        String newFolderId = task.getFolderId();
        if (newFolderId != null && !newFolderId.startsWith("./") && this.folderExists(newFolderId).isEmpty()) {
            task.setFolderId("./");
            return;
        }
    }

    private void validateAndUpdateTemplateId(CreateReleaseTask task) {
        String newTemplateIdPath = TemplateUtils$.MODULE$.normalizeLocalPath(TemplateUtils$.MODULE$.getTemplatePathByTemplateId(task.getTemplateId()));
        if (newTemplateIdPath != null && !newTemplateIdPath.startsWith("./")) {
            Option<Folder> option = this.folderExists(newTemplateIdPath);
            if (option instanceof Some) {
                Some some = (Some)option;
                Folder folder = (Folder)some.value();
                String folderIdByTemplatePath = folder.getId().replace("Applications/", "");
                String templateIdTitle = TemplateUtils$.MODULE$.getTemplateTitleByTemplateId(task.getTemplateId());
                if (this.releaseService.returnReleaseByFolderIdAndReleaseTitle((String)ArrayOps$.MODULE$.last$extension(Predef$.MODULE$.refArrayOps((Object[])folderIdByTemplatePath.split("/"))), templateIdTitle).isEmpty()) {
                    task.setTemplateId(null);
                    return;
                }
                return;
            }
            if (None$.MODULE$.equals(option)) {
                task.setTemplateId(null);
                return;
            }
            throw new MatchError(option);
        }
    }

    private List<CreateReleaseTaskContext> initializeCRTContexts(Release template) {
        ListBuffer updated = ListBuffer$.MODULE$.empty();
        TemplateUtils$.MODULE$.forEachCreateReleaseTask(template, (Function1<CreateReleaseTask, BoxedUnit>)(Function1 & Serializable)task -> {
            TemplateAsCodeService.$anonfun$initializeCRTContexts$1(updated, task);
            return BoxedUnit.UNIT;
        });
        return updated.toList();
    }

    private void resetTemplateCRTFields(Release template, List<CreateReleaseTaskContext> updatedCRTs, boolean returnInitialFields) {
        TemplateUtils$.MODULE$.forEachCreateReleaseTask(template, (Function1<CreateReleaseTask, BoxedUnit>)(Function1 & Serializable)task -> {
            TemplateAsCodeService.$anonfun$resetTemplateCRTFields$1(updatedCRTs, returnInitialFields, task);
            return BoxedUnit.UNIT;
        });
    }

    private void updateCreateReleaseTasks(Release template, List<CreateReleaseTaskContext> updatedCRTs) {
        TemplateUtils$.MODULE$.forEachCreateReleaseTask(template, (Function1<CreateReleaseTask, BoxedUnit>)(Function1 & Serializable)task -> {
            TemplateAsCodeService.$anonfun$updateCreateReleaseTasks$1(updatedCRTs, task);
            return BoxedUnit.UNIT;
        });
    }

    private ImportResult update(ImportContext context, Release existing, Release template) {
        List<CreateReleaseTaskContext> updatedCRTs = this.initializeCRTContexts(template);
        this.setValidFolderAndTemplateIds(template);
        this.populateTemplateData(context, template, existing.getId());
        template.setCiUid(existing.getCiUid());
        this.updateCreateReleaseTasks(template, updatedCRTs);
        this.resetTemplateCRTFields(template, updatedCRTs, false);
        List<ValidationMessage> messages = this.validate(context, template);
        this.resetTemplateCRTFields(template, updatedCRTs, true);
        Release updated = this.releaseRepository.replace(existing, template);
        this.processScmData(context.scmData(), updated);
        this.processFacets((Seq<Facet>)((IterableOnceOps)((IterableOps)CollectionConverters$.MODULE$.ListHasAsScala(updated.getAllTasks()).asScala().filterNot((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)TemplateAsCodeService.$anonfun$update$1(x$2)))).flatMap((Function1 & Serializable)x$3 -> CollectionConverters$.MODULE$.ListHasAsScala(x$3.getFacets()).asScala().toSeq())).toSeq());
        java.util.List templateVars = CollectionConverters$.MODULE$.BufferHasAsJava((Buffer)CollectionConverters$.MODULE$.ListHasAsScala(updated.getVariables()).asScala().withFilter((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.getShowOnReleaseStart())).map((Function1 & Serializable)v -> (Variable)CiCloneHelper.cloneCi((ConfigurationItem)v))).asJava();
        return new ImportResult((List<AsCodeResponse.ChangedIds>)new .colon.colon((Object)AsCodeResponse.EntityKinds$.MODULE$.ExtendedString(AsCodeResponse.EntityKinds$.MODULE$.CI()).ids().withUpdated(updated.getId()), (List)Nil$.MODULE$), (Seq<PostCommitAction>)new .colon.colon(() -> $this.eventBus.publish((XLReleaseEvent)new ReleaseUpdatedFromAsCodeEvent(updated, context.scmData())), (List)new .colon.colon(() -> $this.eventBus.publish((XLReleaseEvent)new TemplateVariablesChangedEvent(updated.getId(), templateVars)), (List)Nil$.MODULE$)), (scala.collection.immutable.Map<String, scala.collection.immutable.Map<Type, AsCodeResponse.ChangedIds>>)Predef$.MODULE$.Map().empty(), messages);
    }

    private List<ValidationMessage> validate(ImportContext context, Release template) {
        Option<ImportValidator> option = context.validator();
        if (option instanceof Some) {
            Some some = (Some)option;
            ImportValidator validator = (ImportValidator)some.value();
            return validator.validateCi((ConfigurationItem)template, context.getFolderInfo(), validator.validateCi$default$3()).toList();
        }
        if (None$.MODULE$.equals(option)) {
            return package$.MODULE$.List().empty();
        }
        throw new MatchError(option);
    }

    private <T extends ConfigurationItem> String generateId(T ci, String parentId) {
        return this.ciIdService.getUniqueId(ci.getType(), parentId);
    }

    public void populateTemplateData(ImportContext context, Release template, String id) {
        Option<String> home = context.scope().getMetadataHome();
        template.setId(id);
        template.setStatus(ReleaseStatus.TEMPLATE);
        if (template.getScheduledStartDate() == null) {
            template.setScheduledStartDate(new Date());
        }
        if (template.getDueDate() == null) {
            if (template.getPlannedDuration() == null) {
                Date nextHour = DateUtils$.MODULE$.addHoursToDate(template.getScheduledStartDate(), 1);
                template.setDueDate(nextHour);
            } else {
                template.setDueDate(new DateTime((Object)template.getScheduledStartDate()).plusSeconds(Predef$.MODULE$.Integer2int(template.getPlannedDuration())).toDate());
            }
        }
        CollectionConverters$.MODULE$.ListHasAsScala(template.getVariables()).asScala().foreach((Function1 & Serializable)variable -> {
            TemplateAsCodeService.$anonfun$populateTemplateData$1(this, template, context, home, variable);
            return BoxedUnit.UNIT;
        });
        this.referenceSolver.resolveStringReference((ConfigurationItem)template, (String)context.scope().getFolderId().getOrElse((Function0 & Serializable)() -> "/"), home, this.referenceSolver.resolveStringReference$default$4());
        CollectionConverters$.MODULE$.ListHasAsScala(template.getPhases()).asScala().foreach((Function1 & Serializable)phase -> {
            this.populatePhaseData(phase, template, (String)context.scope().getFolderId().getOrElse((Function0 & Serializable)() -> "/"), (Option<String>)home, context);
            return BoxedUnit.UNIT;
        });
        ImportContext templateScopedContext = context.copy(new TemplateScope(template.getId(), template.getTitle(), context.scope()), context.copy$default$2(), context.copy$default$3(), context.copy$default$4(), context.copy$default$5(), context.copy$default$6());
        template.getExtensions().forEach(x0$1 -> {
            ReleaseExtension releaseExtension = x0$1;
            if (releaseExtension instanceof Dashboard) {
                Dashboard dashboard = (Dashboard)releaseExtension;
                $this.dashboardAsCodeService.initializeTemplateDashboard(templateScopedContext, dashboard);
                return;
            }
            throw new MatchError((Object)releaseExtension);
        });
    }

    private void populatePhaseData(Phase phase, Release template, String folderId, Option<String> home, ImportContext context) {
        phase.setId(this.generateId(phase, template.getId()));
        phase.setStatus(PhaseStatus.PLANNED);
        phase.setRelease(template);
        CollectionConverters$.MODULE$.ListHasAsScala(phase.getTasks()).asScala().foreach((Function1 & Serializable)task -> {
            this.populateTaskData(task, (TaskContainer)phase, template, folderId, (Option<String>)home, context);
            return BoxedUnit.UNIT;
        });
    }

    private void populateTaskData(Task task, TaskContainer container, Release template, String folderId, Option<String> home, ImportContext context) {
        task.setId(this.generateId(task, container.getId()));
        task.setStatus(TaskStatus.PLANNED);
        task.setContainer(container);
        CollectionConverters$.MODULE$.ListHasAsScala(task.getFacets()).asScala().foreach((Function1 & Serializable)facet -> {
            TemplateAsCodeService.$anonfun$populateTaskData$1(this, task, folderId, home, facet);
            return BoxedUnit.UNIT;
        });
        this.referenceSolver.resolveStringReference((ConfigurationItem)task, folderId, home, (scala.collection.immutable.Map<String, String>)context.templateIds().view().mapValues((Function1 & Serializable)x$5 -> (String)x$5._1()).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
        VariablePersistenceHelper$.MODULE$.scanAndBuildNewVariables(task.getRelease(), (VisitableItem)task, this.ciIdService);
        Task task2 = task;
        if (task2 instanceof CustomScriptTask) {
            CustomScriptTask customScriptTask = (CustomScriptTask)task2;
            this.populateCustomScriptTask(customScriptTask);
            return;
        }
        if (task2 instanceof CreateReleaseTask) {
            CreateReleaseTask createReleaseTask = (CreateReleaseTask)task2;
            this.populateCreateReleaseTask(createReleaseTask, context);
            return;
        }
        if (task2 instanceof GateTask) {
            GateTask gateTask = (GateTask)task2;
            this.populateGateTask(gateTask);
            return;
        }
        if (task2 instanceof TaskGroup) {
            TaskGroup taskGroup = (TaskGroup)task2;
            this.populateTaskGroup(taskGroup, template, folderId, home, context);
            return;
        }
        if (task2 instanceof UserInputTask) {
            UserInputTask userInputTask = (UserInputTask)task2;
            this.populateUserInputTask(userInputTask, (Buffer<Variable>)CollectionConverters$.MODULE$.ListHasAsScala(template.getVariables()).asScala());
            return;
        }
    }

    private void populateUserInputTask(UserInputTask task, Buffer<Variable> variables) {
        scala.collection.immutable.Map varMap = ((IterableOnceOps)variables.map((Function1 & Serializable)variable -> new Tuple2((Object)variable.getKey(), variable))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        Buffer usedVars = (Buffer)((IterableOps)CollectionConverters$.MODULE$.ListHasAsScala(task.getVariables()).asScala().filter((Function1 & Serializable)taskVar -> BoxesRunTime.boxToBoolean((boolean)varMap.contains((Object)taskVar.getKey())))).map((Function1 & Serializable)taskVar -> (Variable)varMap.apply((Object)taskVar.getKey()));
        task.setVariables(CollectionConverters$.MODULE$.BufferHasAsJava(usedVars).asJava());
    }

    private void populateCustomScriptTask(CustomScriptTask task) {
        PythonScript pythonScript = task.getPythonScript();
        pythonScript.setId(task.getId() + "/PythonScript");
        pythonScript.setCustomScriptTask(task);
    }

    private void populateCreateReleaseTask(CreateReleaseTask task, ImportContext context) {
        block5: {
            try {
                scala.collection.immutable.Map importingTemplatesById = context.templateIds().view().values().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
                Option option = Option$.MODULE$.apply((Object)task.getTemplateId()).flatMap((Function1 & Serializable)templateId -> importingTemplatesById.get(templateId).orElse((Function0 & Serializable)() -> Try$.MODULE$.apply((Function0 & Serializable)() -> $this.releaseRepository.findById(templateId, ResolveOptions$.MODULE$.WITHOUT_DECORATORS())).toOption()));
                if (option instanceof Some) {
                    Some some = (Some)option;
                    Release template = (Release)some.value();
                    Map templateVariables = template.getVariablesByKeys();
                    CollectionConverters$.MODULE$.ListHasAsScala(task.getTemplateVariables()).asScala().foreach((Function1 & Serializable)variable -> {
                        TemplateAsCodeService.$anonfun$populateCreateReleaseTask$4(templateVariables, variable);
                        return BoxedUnit.UNIT;
                    });
                    break block5;
                }
                if (None$.MODULE$.equals(option)) {
                    break block5;
                }
                throw new MatchError((Object)option);
            }
            catch (NotFoundException notFoundException) {
                this.logger().warn((Function0 & Serializable)() -> "Unable to process target template for create release task - " + task.getId());
            }
            catch (Exception e) {
                throw e;
            }
        }
        CollectionConverters$.MODULE$.ListHasAsScala(task.getTemplateVariables()).asScala().foreach((Function1 & Serializable)variable -> {
            TemplateAsCodeService.$anonfun$populateCreateReleaseTask$6(this, task, variable);
            return BoxedUnit.UNIT;
        });
    }

    private void populateGateTask(GateTask task) {
        CollectionConverters$.MODULE$.ListHasAsScala(task.getConditions()).asScala().foreach((Function1 & Serializable)condition -> {
            condition.setId(this.ciIdService.getUniqueId(condition.getType(), task.getId()));
            return BoxedUnit.UNIT;
        });
        CollectionConverters$.MODULE$.ListHasAsScala(task.getDependencies()).asScala().foreach((Function1 & Serializable)dep -> {
            TemplateAsCodeService.$anonfun$populateGateTask$2(this, task, dep);
            return BoxedUnit.UNIT;
        });
    }

    private void populateTaskGroup(TaskGroup group, Release template, String folderId, Option<String> home, ImportContext context) {
        CollectionConverters$.MODULE$.ListHasAsScala(group.getTasks()).asScala().foreach((Function1 & Serializable)task -> {
            this.populateTaskData(task, (TaskContainer)group, template, folderId, (Option<String>)home, context);
            return BoxedUnit.UNIT;
        });
        TaskGroup taskGroup = group;
        if (taskGroup instanceof ParallelGroup) {
            ParallelGroup parallelGroup = (ParallelGroup)taskGroup;
            if (!parallelGroup.getLinks().isEmpty()) {
                scala.collection.immutable.Map nameToTask = ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(parallelGroup.getTasks()).asScala().map((Function1 & Serializable)task -> new Tuple2((Object)task.getTitle(), task))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
                CollectionConverters$.MODULE$.SetHasAsScala(parallelGroup.getLinks()).asScala().foreach((Function1 & Serializable)link -> {
                    TemplateAsCodeService.$anonfun$populateTaskGroup$3(this, group, nameToTask, link);
                    return BoxedUnit.UNIT;
                });
                return;
            }
            return;
        }
    }

    private void processScmData(Option<SCMTraceabilityData> data, Release template) {
        data.filterNot((Function1 & Serializable)scmData -> BoxesRunTime.boxToBoolean((boolean)Utils$.MODULE$.isSCMDataEmpty(scmData))).foreach((Function1 & Serializable)x$7 -> $this.releaseService.createSCMData(template.getId(), x$7));
    }

    public static final /* synthetic */ void $anonfun$setValidFolderAndTemplateIds$1(TemplateAsCodeService $this, CreateReleaseTask task) {
        $this.validateAndUpdateFolderId(task);
        $this.validateAndUpdateTemplateId(task);
    }

    public static final /* synthetic */ void $anonfun$initializeCRTContexts$1(ListBuffer updated$1, CreateReleaseTask task) {
        CreateReleaseTaskSnapshot taskSnapshot = new CreateReleaseTaskSnapshot(task.getId(), task.getTemplateId(), task.getFolderId());
        updated$1.$plus$eq((Object)new CreateReleaseTaskContext(taskSnapshot, taskSnapshot, task));
    }

    public static final /* synthetic */ boolean $anonfun$resetTemplateCRTFields$2(CreateReleaseTask task$1, CreateReleaseTaskContext updated) {
        String string = updated.original().getId();
        String string2 = task$1.getId();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$resetTemplateCRTFields$3(boolean returnInitialFields$1, CreateReleaseTask task$1, CreateReleaseTaskContext updatedTask) {
        CreateReleaseTaskSnapshot sourceSnapshot = returnInitialFields$1 ? updatedTask.updated() : updatedTask.saved();
        task$1.setTemplateId(sourceSnapshot.templateId());
        task$1.setFolderId(sourceSnapshot.folderId());
        task$1.setId(updatedTask.original().getId());
    }

    public static final /* synthetic */ void $anonfun$resetTemplateCRTFields$1(List updatedCRTs$1, boolean returnInitialFields$1, CreateReleaseTask task) {
        updatedCRTs$1.find((Function1 & Serializable)updated -> BoxesRunTime.boxToBoolean((boolean)TemplateAsCodeService.$anonfun$resetTemplateCRTFields$2(task, updated))).foreach((Function1 & Serializable)updatedTask -> {
            TemplateAsCodeService.$anonfun$resetTemplateCRTFields$3(returnInitialFields$1, task, updatedTask);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$updateCreateReleaseTasks$2(CreateReleaseTask task$2, CreateReleaseTaskContext ucs) {
        String string = ucs.original().getId();
        String string2 = task$2.getId();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$updateCreateReleaseTasks$1(List updatedCRTs$2, CreateReleaseTask task) {
        updatedCRTs$2.find((Function1 & Serializable)ucs -> BoxesRunTime.boxToBoolean((boolean)TemplateAsCodeService.$anonfun$updateCreateReleaseTasks$2(task, ucs))).foreach((Function1 & Serializable)updatedTask -> {
            updatedTask.updated_$eq(new CreateReleaseTaskSnapshot(updatedTask.original().getId(), task.getTemplateId(), task.getFolderId()));
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$update$1(Task x$2) {
        return x$2.getFacets().isEmpty();
    }

    public static final /* synthetic */ void $anonfun$populateTemplateData$1(TemplateAsCodeService $this, Release template$3, ImportContext context$6, Option home$1, Variable variable) {
        VariablePersistenceHelper$.MODULE$.fixUpReleaseVariable(variable, template$3.getId(), $this.ciIdService);
        $this.referenceSolver.resolveStringReference((ConfigurationItem)variable, (String)context$6.scope().getFolderId().getOrElse((Function0 & Serializable)() -> "/"), (Option<String>)home$1, $this.referenceSolver.resolveStringReference$default$4());
    }

    public static final /* synthetic */ void $anonfun$populateTaskData$1(TemplateAsCodeService $this, Task task$3, String folderId$2, Option home$3, Facet facet) {
        facet.setTargetId(task$3.getId());
        $this.referenceSolver.resolveStringReference((ConfigurationItem)facet, folderId$2, (Option<String>)home$3, $this.referenceSolver.resolveStringReference$default$4());
    }

    public static final /* synthetic */ void $anonfun$populateCreateReleaseTask$4(Map templateVariables$1, Variable variable) {
        Variable templateVariable = templateVariables$1.getOrDefault(variable.getKey(), variable);
        variable.setValueProvider(templateVariable.getValueProvider());
    }

    public static final /* synthetic */ void $anonfun$populateCreateReleaseTask$6(TemplateAsCodeService $this, CreateReleaseTask task$4, Variable variable) {
        variable.setId($this.generateId(variable, task$4.getId()));
        Option$.MODULE$.apply((Object)variable.getValueProvider()).foreach((Function1 & Serializable)x$6 -> {
            x$6.setId(variable.getId() + "/valueProvider");
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$populateGateTask$2(TemplateAsCodeService $this, GateTask task$5, Dependency dep) {
        if (!VariableHelper$.MODULE$.containsVariables(dep.getTargetId())) {
            throw new AsCodeException("Gate tasks with hardcoded release dependencies cannot be applied, change the dependency to using a variable instead.", AsCodeException$.MODULE$.$lessinit$greater$default$2());
        }
        dep.setId($this.ciIdService.getUniqueId(dep.getType(), task$5.getId()));
    }

    public static final /* synthetic */ void $anonfun$populateTaskGroup$3(TemplateAsCodeService $this, TaskGroup group$1, scala.collection.immutable.Map nameToTask$1, Link link) {
        link.setId($this.generateId(link, group$1.getId()));
        link.setSource((Task)nameToTask$1.apply((Object)link.getSource().getTitle()));
        link.setTarget((Task)nameToTask$1.apply((Object)link.getTarget().getTitle()));
    }

    @Autowired
    public TemplateAsCodeService(ReleaseService releaseService, DashboardAsCodeService dashboardAsCodeService, ReferenceSolver referenceSolver, ReleaseRepository releaseRepository, CiIdService ciIdService, XLReleaseEventBus eventBus, FacetRepositoryDispatcher facetRepositoryDispatcher, FacetService facetService, FolderService folderService) {
        this.releaseService = releaseService;
        this.dashboardAsCodeService = dashboardAsCodeService;
        this.referenceSolver = referenceSolver;
        this.releaseRepository = releaseRepository;
        this.ciIdService = ciIdService;
        this.eventBus = eventBus;
        this.facetRepositoryDispatcher = facetRepositoryDispatcher;
        this.facetService = facetService;
        this.folderService = folderService;
        Logging.$init$((Logging)this);
    }
}

