package com.xebialabs.xlrelease.ascode.service.referencehandler.stringhandler

import com.xebialabs.ascode.exception.AsCodeException
import com.xebialabs.xlrelease.domain.environments.EnvironmentStage
import com.xebialabs.xlrelease.environments.service.EnvironmentStageService
import com.xebialabs.xlrelease.repository.Ids
import com.xebialabs.xlrelease.udm.reporting.filters.EnvironmentStageFilter
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Component

import scala.util.{Failure, Success, Try}

@Component
@Autowired
class EnvironmentStageFilterStringReferenceCreationHandler(environmentStageService: EnvironmentStageService) extends StringReferenceCreationHandler {
  override def isDefinedAt(config: StringReferenceCreationConfig): Boolean = config.ci.isInstanceOf[EnvironmentStageFilter]

  override def apply(config: StringReferenceCreationConfig): StringReferenceContainer = {
    val filter = config.ci.asInstanceOf[EnvironmentStageFilter]
    val stageName = filter.getEnvironmentStageId
    val descriptor = filter.getType.getDescriptor.getPropertyDescriptor("environmentStageId")

    val stage: EnvironmentStage = Try(environmentStageService.findStageByTitle(stageName)) match {
      case Success(stage) => stage
      case Failure(_) => throw new AsCodeException(s"Stage with name $stageName was not found. Please create it first before using it.")
    }
    config.ci.setId("-1")
    StringReferenceContainer(config.ci, Map(descriptor -> Some(Ids.getName(stage.getId))))
  }
}
