import React, { useState } from 'react';
import { DotThemeProvider } from '@digital-ai/dot-components';
import { ReactDiffView } from './compare/react-diff-view.component';
import './git-yaml-diff-viewer.component.less';

export const GitYamlDiffViewer = ({ compareData }: { compareData: string }) => {
    const [diffContent] = useState(compareData.toString());
    return (
        <DotThemeProvider>
            <div className="react-diff-viewer">{diffContent ? <ReactDiffView diffString={diffContent} /> : <p>No diff data available</p>}</div>
        </DotThemeProvider>
    );
};
