import React from 'react';
import { mount } from 'enzyme';
import { GitYamlDiffViewer } from './git-yaml-diff-viewer.component';

describe('GitYamlDiffViewer', () => {
    const diffString = [
        '--- a/S125649/v5/Template_t1.yaml',
        '+++ b/S125649/v3/Template_t1.yaml',
        '@@ -1,25 +1,24 @@',
        ' # Exported from:        http://local:5516/',
        ' # Release version:      24.1.0',
        '-# Date created:         Thu Nov 13 13:04:02 CET 2025',
        '+# Date created:         Thu Nov 13 10:52:22 CET 2025',
        ' ',
        '---',
        'apiVersion: xl-release/v1',
        'kind: Templates',
        'metadata:',
        '  path: /',
        '  home: S-125649',
        'spec:',
        '-  template: T1',
        '  scheduledStartDate: 2025-11-13T04:30:00+01:00',
        '-  dueDate: 2025-11-13T05:30:00+01:00',
        '  phases:',
        '  - phase: New Phase',
        '    tasks:',
        '-    - name: T1.0',
        '+    - name: T1',
        '      type: xlrelease.Task',
        '-    - name: T2.0',
        '+    - name: T2',
        '      type: xlrelease.Task',
        '    - name: T3',
        '      type: xlrelease.Task',
        '  riskProfile: Default risk profile',
        '  author: admin',
    ].join('\n');

    test('should render diff content when compareData is provided', () => {
        const wrapper = mount(<GitYamlDiffViewer compareData={diffString} />);
        expect(wrapper.find('.react-diff-viewer').exists()).toBeTruthy();
        expect(wrapper.text()).toContain('# Date created:         Thu Nov 13 13:04:02 CET 2025');
        expect(wrapper.text()).toContain('# Date created:         Thu Nov 13 10:52:22 CET 2025');
        expect(wrapper.text()).toContain('apiVersion: xl-release/v1');
    });

    test('should show "No diff data available" when compareData is empty', () => {
        const wrapper = mount(<GitYamlDiffViewer compareData={''} />);
        expect(wrapper.text()).toContain('No diff data available');
    });
});
