package com.xebialabs.xlrelease.ascode.service.referencehandler.stringhandler

import com.xebialabs.ascode.utils.TypeSugar._
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor
import com.xebialabs.xlrelease.ascode.service.FolderAsCodeService
import com.xebialabs.xlrelease.ascode.service.referencehandler.stringhandler.TemplateStringReferenceCreationHandler._
import com.xebialabs.xlrelease.domain.Release
import com.xebialabs.xlrelease.domain.Release.DEFAULT_TARGET_FOLDER_ID_PROPERTY_NAME
import org.springframework.stereotype.Component

object TemplateStringReferenceCreationHandler {
  private def defaultTargetFolderIdDescriptor: PropertyDescriptor = typeOf[Release].getDescriptor.getPropertyDescriptor(DEFAULT_TARGET_FOLDER_ID_PROPERTY_NAME)
}

@Component
class TemplateStringReferenceCreationHandler(folderAsCodeService: FolderAsCodeService)
  extends StringReferenceCreationHandler {

  override def isDefinedAt(config: StringReferenceCreationConfig): Boolean = {
    config.ci.isInstanceOf[Release] && (defaultTargetFolderIdDescriptor.get(config.ci) != null)
  }

  override def apply(config: StringReferenceCreationConfig): StringReferenceContainer = {
    val defaultTargetFolderId = TemplateStringReferenceCreationUtil.mapFolderIdToProp(config, defaultTargetFolderIdDescriptor, folderAsCodeService)
    StringReferenceContainer(config.ci, defaultTargetFolderId.toMap)
  }
}
