package com.xebialabs.xlrelease.ascode.service.referencehandler.cireferencehandler

import com.xebialabs.ascode.utils.TypeSugar._
import com.xebialabs.xlrelease.domain._
import com.xebialabs.xlrelease.service.SharedConfigurationService
import com.xebialabs.xlrelease.utils.TypeHelper
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.core.annotation.Order
import org.springframework.stereotype.Component

import scala.jdk.CollectionConverters._

@Component
@Order(1000)
class ConfigurationCiReferenceCreationHandler @Autowired()(
                                                            sharedConfigurationService: SharedConfigurationService
                                                          ) extends CiReferenceCreationHandler {
  override def isDefinedAt(helper: CiReferenceCreationConfig): Boolean = {
    Option(helper.propertyDescriptor.getReferencedType).exists { referencedType =>
      TypeHelper.getAllSubtypesOf(referencedType).exists(_.instanceOf(typeOf[Configuration]))
    }
  }

  override def apply(config: CiReferenceCreationConfig): Option[AnyRef] = {
    config.reference.getIds.asScala.flatMap { referencedName =>
      sharedConfigurationService.searchByTypeAndTitle(config.propertyDescriptor.getReferencedType, referencedName, config.folderPath, false).asScala
        .sortBy(ci => Option(ci.getFolderId).getOrElse(""))(Ordering.String.reverse)
        .headOption
    }.headOption
  }
}
