package com.xebialabs.xlrelease.ascode.service.referencehandler.cireferencehandler

import com.xebialabs.xlrelease.domain.variables.StringVariable
import org.springframework.core.annotation.Order
import org.springframework.stereotype.Component

import scala.jdk.CollectionConverters._

@Component
@Order(1)
class UserInputCiReferenceCreationHandler extends CiReferenceCreationHandler {
  private val properties: Set[String] = Set("xlrelease.UserInputTask.variables")

  override def isDefinedAt(helper: CiReferenceCreationConfig): Boolean = properties.contains(helper.propertyDescriptor.getFqn)

  private def newVariable(name: String): StringVariable =  {
    // variable type is irrelevant just need something that isn't abstract, it will be swapped out for the actual matching release variable later
    val v = new StringVariable
    v.setKey(name)
    v
  }

  override def apply(config: CiReferenceCreationConfig): Option[AnyRef] = {
    // The actual variable list has been removed from the task by something, maybe the yaml parser when building the references list???
    // rebuild it as it originally was so it can be rewritten and it will actually be handled in the TemplateAsCodeParser
    Option(config.reference.getIds.asScala.map(newVariable(_)).toList.asJava)
  }
}
