package com.xebialabs.xlrelease.versioning.ascode.actors

import com.xebialabs.xlrelease.domain.versioning.ascode.FolderVersioningSettings
import com.xebialabs.xlrelease.scm.data.VersionInfo
import com.xebialabs.xlrelease.versioning.ascode.actors.FolderVersioningActor._
import com.xebialabs.xlrelease.versioning.ascode.actors.FolderVersioningActorInitializer.FolderVersioningActorHolder
import grizzled.slf4j.Logging
import org.springframework.stereotype.Component

import java.util.Date

@Component
class FolderVersioningActorService(folderVersioningActorHolder: FolderVersioningActorHolder) extends Logging {

  def fetchChanges(folderId: String): (Date, Seq[VersionInfo]) = askAndAwait {
    FetchChanges(folderId)
  }

  def createVersion(folderId: String, version: String, description: String): VersionInfo = askAndAwait {
    CreateVersion(folderId, version, description)
  }

  def createOrUpdateSettings(config: FolderVersioningSettings): FolderVersioningSettings = askAndAwait {
    CreateOrUpdateSettings(config)
  }

  def cleanLocalRepo(folderId: String, clusterWide: Boolean): Unit = {
    folderVersioningActorHolder ! CleanLocalRepo(folderId, clusterWide)
  }

  def resetLocalRepo(settings: FolderVersioningSettings, clusterWide: Boolean): Unit = {
    folderVersioningActorHolder ! ResetLocalRepo(settings, clusterWide)
  }

  def clearSecrets(folderId: String): Unit = {
    folderVersioningActorHolder ! ClearSecrets(folderId)
  }

  private def askAndAwait[T](msg: AnyRef): T = folderVersioningActorHolder.askAndAwait(msg)
}
