/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.ascode.service;

import com.xebialabs.ascode.exception.AsCodeException;
import com.xebialabs.ascode.exception.AsCodeException$;
import com.xebialabs.xlplatform.coc.service.SCMTraceabilityService;
import com.xebialabs.xlrelease.api.internal.ReleaseResource;
import com.xebialabs.xlrelease.api.v1.FolderApi;
import com.xebialabs.xlrelease.api.v1.ReleaseApi;
import com.xebialabs.xlrelease.api.v1.RiskApi;
import com.xebialabs.xlrelease.api.v1.TemplateApi;
import com.xebialabs.xlrelease.api.v1.forms.CreateRelease;
import com.xebialabs.xlrelease.api.v1.forms.StartRelease;
import com.xebialabs.xlrelease.ascode.service.FolderAsCodeService;
import com.xebialabs.xlrelease.ascode.utils.Utils$;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.service.FolderService;
import com.xebialabs.xlrelease.service.ReleaseService;
import java.io.Serializable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.Try$;

@Service
@ScalaSignature(bytes="\u0006\u0005\u0005\u0005c\u0001\u0002\u0007\u000e\u0001aA\u0001b\b\u0001\u0003\u0002\u0003\u0006I\u0001\t\u0005\tQ\u0001\u0011\t\u0011)A\u0005S!Aa\u0006\u0001B\u0001B\u0003%q\u0006\u0003\u00053\u0001\t\u0005\t\u0015!\u00034\u0011!1\u0004A!A!\u0002\u00139\u0004\u0002C\u001f\u0001\u0005\u0003\u0005\u000b\u0011\u0002 \t\u0011\t\u0003!\u0011!Q\u0001\n\rC\u0001B\u0012\u0001\u0003\u0002\u0003\u0006Ia\u0012\u0005\t\u0015\u0002\u0011\t\u0011)A\u0005\u0017\")A\u000b\u0001C\u0001+\")q\u000e\u0001C\u0001a\n!\"+\u001a7fCN,\u0017i]\"pI\u0016\u001cVM\u001d<jG\u0016T!AD\b\u0002\u000fM,'O^5dK*\u0011\u0001#E\u0001\u0007CN\u001cw\u000eZ3\u000b\u0005I\u0019\u0012!\u0003=me\u0016dW-Y:f\u0015\t!R#A\u0005yK\nL\u0017\r\\1cg*\ta#A\u0002d_6\u001c\u0001a\u0005\u0002\u00013A\u0011!$H\u0007\u00027)\tA$A\u0003tG\u0006d\u0017-\u0003\u0002\u001f7\t1\u0011I\\=SK\u001a\f1\u0002^3na2\fG/Z!qSB\u0011\u0011EJ\u0007\u0002E)\u00111\u0005J\u0001\u0003mFR!!J\t\u0002\u0007\u0005\u0004\u0018.\u0003\u0002(E\tYA+Z7qY\u0006$X-\u00119j\u000351w\u000e\u001c3feN+'O^5dKB\u0011!\u0006L\u0007\u0002W)\u0011a\"E\u0005\u0003[-\u0012QBR8mI\u0016\u00148+\u001a:wS\u000e,\u0017!\u00034pY\u0012,'/\u00119j!\t\t\u0003'\u0003\u00022E\tIai\u001c7eKJ\f\u0005/[\u0001\u000fe\u0016dW-Y:f'\u0016\u0014h/[2f!\tQC'\u0003\u00026W\tq!+\u001a7fCN,7+\u001a:wS\u000e,\u0017a\u0004:fY\u0016\f7/\u001a*fg>,(oY3\u0011\u0005aZT\"A\u001d\u000b\u0005i\"\u0013\u0001C5oi\u0016\u0014h.\u00197\n\u0005qJ$a\u0004*fY\u0016\f7/\u001a*fg>,(oY3\u0002'\u0019|G\u000eZ3s\u0003N\u001cu\u000eZ3TKJ4\u0018nY3\u0011\u0005}\u0002U\"A\u0007\n\u0005\u0005k!a\u0005$pY\u0012,'/Q:D_\u0012,7+\u001a:wS\u000e,\u0017A\u0003:fY\u0016\f7/Z!qSB\u0011\u0011\u0005R\u0005\u0003\u000b\n\u0012!BU3mK\u0006\u001cX-\u00119j\u0003\u001d\u0011\u0018n]6Ba&\u0004\"!\t%\n\u0005%\u0013#a\u0002*jg.\f\u0005/[\u0001\u0017g\u000elGK]1dK\u0006\u0014\u0017\u000e\\5usN+'O^5dKB\u0011AJU\u0007\u0002\u001b*\u0011aB\u0014\u0006\u0003\u001fB\u000b1aY8d\u0015\t\t6#\u0001\u0006yYBd\u0017\r\u001e4pe6L!aU'\u0003-M\u001bU\n\u0016:bG\u0016\f'-\u001b7jif\u001cVM\u001d<jG\u0016\fa\u0001P5oSRtDC\u0003,X1fS6\fX/_?B\u0011q\b\u0001\u0005\u0006?)\u0001\r\u0001\t\u0005\u0006Q)\u0001\r!\u000b\u0005\u0006])\u0001\ra\f\u0005\u0006e)\u0001\ra\r\u0005\u0006m)\u0001\ra\u000e\u0005\u0006{)\u0001\rA\u0010\u0005\u0006\u0005*\u0001\ra\u0011\u0005\u0006\r*\u0001\ra\u0012\u0005\u0006\u0015*\u0001\ra\u0013\u0015\u0003\u0015\u0005\u0004\"AY7\u000e\u0003\rT!\u0001Z3\u0002\u0015\u0005tgn\u001c;bi&|gN\u0003\u0002gO\u00069a-Y2u_JL(B\u00015j\u0003\u0015\u0011W-\u00198t\u0015\tQ7.A\btaJLgn\u001a4sC6,wo\u001c:l\u0015\u0005a\u0017aA8sO&\u0011an\u0019\u0002\n\u0003V$xn^5sK\u0012\fAb\u001d;beR\u0014V\r\\3bg\u0016$2\"]A\t\u0003+\tI\"a\b\u0002*Q\u0011!\u000f\u001f\t\u0003gZl\u0011\u0001\u001e\u0006\u0003kF\ta\u0001Z8nC&t\u0017BA<u\u0005\u001d\u0011V\r\\3bg\u0016DQ!_\u0006A\u0004i\f\u0001\"\\3uC\u0012\fG/\u0019\t\bw\u0006\u0015\u00111BA\u0006\u001d\ra\u0018\u0011\u0001\t\u0003{ni\u0011A \u0006\u0003\u007f^\ta\u0001\u0010:p_Rt\u0014bAA\u00027\u00051\u0001K]3eK\u001aLA!a\u0002\u0002\n\t\u0019Q*\u00199\u000b\u0007\u0005\r1\u0004E\u0002|\u0003\u001bIA!a\u0004\u0002\n\t11\u000b\u001e:j]\u001eDq!a\u0005\f\u0001\u0004\tY!\u0001\u0007uK6\u0004H.\u0019;f!\u0006$\b\u000eC\u0004\u0002\u0018-\u0001\r!a\u0003\u0002\u0017I,G.Z1tKB\u000bG\u000f\u001b\u0005\b\u00037Y\u0001\u0019AA\u000f\u0003%1\u0018M]5bE2,7\u000f\u0005\u0004|\u0003\u000b\tY!\u0007\u0005\b\u0003CY\u0001\u0019AA\u0012\u0003%\tW\u000f^8Ti\u0006\u0014H\u000fE\u0002\u001b\u0003KI1!a\n\u001c\u0005\u001d\u0011un\u001c7fC:Dq!a\u000b\f\u0001\u0004\ti#A\u0006sSN\\\u0007K]8gS2,\u0007#\u0002\u000e\u00020\u0005-\u0011bAA\u00197\t1q\n\u001d;j_:D3\u0001AA\u001b!\u0011\t9$!\u0010\u000e\u0005\u0005e\"bAA\u001eS\u0006Q1\u000f^3sK>$\u0018\u0010]3\n\t\u0005}\u0012\u0011\b\u0002\b'\u0016\u0014h/[2f\u0001")
public class ReleaseAsCodeService {
    private final TemplateApi templateApi;
    private final ReleaseService releaseService;
    private final FolderAsCodeService folderAsCodeService;
    private final ReleaseApi releaseApi;
    private final RiskApi riskApi;
    private final SCMTraceabilityService scmTraceabilityService;

    public Release startRelease(String templatePath, String releasePath, Map<String, Object> variables, boolean autoStart, Option<String> riskProfile, Map<String, String> metadata) {
        StartRelease startRelease = new StartRelease();
        String templateTitle = Ids.getName((String)templatePath);
        String releaseTitle = Ids.getName((String)releasePath);
        Option templateFolder = (Option)Try$.MODULE$.apply((Function0 & Serializable)() -> $this.folderAsCodeService.searchParentFolder(templatePath, metadata)).getOrElse((Function0 & Serializable)() -> None$.MODULE$);
        Option releaseFolderId = (Option)Try$.MODULE$.apply((Function0 & Serializable)() -> $this.folderAsCodeService.searchParentFolder(releasePath, metadata)).getOrElse((Function0 & Serializable)() -> None$.MODULE$);
        Option profile = riskProfile.map((Function1 & Serializable)title -> $this.riskApi.getRiskProfileByTitle(title));
        List templatesInFolder = Utils$.MODULE$.filterCisByFolder(CollectionConverters$.MODULE$.ListHasAsScala(this.releaseService.findTemplatesByTitle((String)templateFolder.map((Function1 & Serializable)x$1 -> x$1.getId()).getOrElse((Function0 & Serializable)() -> "/"), templateTitle, 0, 2, 1)).asScala().toList(), (String)templateFolder.map((Function1 & Serializable)x$2 -> x$2.getId()).getOrElse((Function0 & Serializable)() -> "/"));
        List list = templatesInFolder;
        if (list instanceof .colon.colon) {
            .colon.colon colon2 = (.colon.colon)list;
            Release template = (Release)colon2.head();
            List list2 = colon2.next$access$1();
            if (Nil$.MODULE$.equals(list2)) {
                startRelease.setFolderId((String)releaseFolderId.map((Function1 & Serializable)x$3 -> x$3.getId()).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()));
                startRelease.setVariables(CollectionConverters$.MODULE$.MapHasAsJava(variables).asJava());
                startRelease.setReleaseTitle(releaseTitle);
                Release createdRelease = this.templateApi.create(template.getId(), (CreateRelease)startRelease);
                Option scmDataId = Option$.MODULE$.apply((Object)createdRelease.get$ciAttributes().getScmTraceabilityDataId());
                Option scmData = scmDataId.flatMap((Function1 & Serializable)id -> $this.scmTraceabilityService.getById(id));
                profile.foreach((Function1 & Serializable)x$4 -> {
                    createdRelease.setProperty("riskProfile", (Object)x$4);
                    return BoxedUnit.UNIT;
                });
                Release updatedRelease = this.releaseApi.updateRelease(createdRelease);
                scmData.foreach((Function1 & Serializable)x$5 -> $this.releaseService.createSCMData(updatedRelease.getId(), x$5));
                if (autoStart) {
                    return this.releaseApi.start(updatedRelease.getId());
                }
                return updatedRelease;
            }
        }
        if (Nil$.MODULE$.equals(list)) {
            throw new AsCodeException("No templates with the name [" + templatePath + "] were found.", AsCodeException$.MODULE$.$lessinit$greater$default$2());
        }
        throw new AsCodeException("There is more than one template with the name [" + templatePath + "]. Please introduce an unique name.", AsCodeException$.MODULE$.$lessinit$greater$default$2());
    }

    @Autowired
    public ReleaseAsCodeService(TemplateApi templateApi, FolderService folderService, FolderApi folderApi, ReleaseService releaseService, ReleaseResource releaseResource, FolderAsCodeService folderAsCodeService, ReleaseApi releaseApi, RiskApi riskApi, SCMTraceabilityService scmTraceabilityService) {
        this.templateApi = templateApi;
        this.releaseService = releaseService;
        this.folderAsCodeService = folderAsCodeService;
        this.releaseApi = releaseApi;
        this.riskApi = riskApi;
        this.scmTraceabilityService = scmTraceabilityService;
    }
}

