/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.ascode.service;

import com.xebialabs.ascode.exception.AsCodeException;
import com.xebialabs.ascode.exception.AsCodeException$;
import com.xebialabs.ascode.yaml.dto.AsCodeResponse;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.xlrelease.ascode.metadata.MetadataFields$;
import com.xebialabs.xlrelease.ascode.service.FolderAsCodeService$;
import com.xebialabs.xlrelease.ascode.service.ImportResult;
import com.xebialabs.xlrelease.ascode.service.PostCommitAction;
import com.xebialabs.xlrelease.ascode.service.ReferenceSolver;
import com.xebialabs.xlrelease.ascode.utils.ImportContext;
import com.xebialabs.xlrelease.builder.ReleaseBuilder;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.ReleaseTrigger;
import com.xebialabs.xlrelease.domain.Trigger;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.domain.variables.Variable;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.exception.LogFriendlyNotFoundException;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.repository.TriggerRepository;
import com.xebialabs.xlrelease.serialization.json.repository.ResolveOptions$;
import com.xebialabs.xlrelease.service.CiIdService;
import com.xebialabs.xlrelease.service.FolderService;
import com.xebialabs.xlrelease.service.ReleaseService;
import com.xebialabs.xlrelease.triggers.actors.TriggerLifecycle;
import com.xebialabs.xlrelease.triggers.deployment_based.StatusWebhookTrigger;
import com.xebialabs.xlrelease.triggers.event_based.EventBasedTrigger;
import com.xebialabs.xlrelease.triggers.events.TriggerCreatedFromAsCodeEvent;
import com.xebialabs.xlrelease.triggers.events.TriggerUpdatedFromAsCodeEvent;
import com.xebialabs.xlrelease.triggers.service.TriggerService;
import com.xebialabs.xlrelease.utils.CiHelper;
import com.xebialabs.xlrelease.utils.FolderId;
import com.xebialabs.xlrelease.versioning.ascode.ImportValidator;
import com.xebialabs.xlrelease.versioning.ascode.ValidationMessage;
import com.xebialabs.xlrelease.webhooks.mapping.MappedProperty;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@Service
@ScalaSignature(bytes="\u0006\u0005\tEa\u0001B\u000e\u001d\u0001\u001dB\u0001B\u000e\u0001\u0003\u0002\u0003\u0006Ia\u000e\u0005\t{\u0001\u0011\t\u0011)A\u0005}!A\u0011\t\u0001B\u0001B\u0003%!\t\u0003\u0005H\u0001\t\u0005\t\u0015!\u0003I\u0011!Y\u0005A!A!\u0002\u0013a\u0005\u0002\u0003)\u0001\u0005\u0003\u0005\u000b\u0011B)\t\u0011}\u0003!\u0011!Q\u0001\n\u0001D\u0001b\u0019\u0001\u0003\u0002\u0003\u0006I\u0001\u001a\u0005\tS\u0002\u0011\t\u0011)A\u0005U\")\u0001\u000f\u0001C\u0001c\"9\u0011q\u0003\u0001\u0005\u0002\u0005e\u0001bBA\u001b\u0001\u0011%\u0011q\u0007\u0005\b\u0003\u0007\u0002A\u0011BA#\u0011\u001d\t)\u0007\u0001C\u0005\u0003OBq!!\u001d\u0001\t\u0013\t\u0019\bC\u0004\u0002\u001a\u0002!I!a'\t\u000f\u0005\r\u0006\u0001\"\u0003\u0002&\"9\u0011Q\u0017\u0001\u0005\n\u0005]\u0006bBA_\u0001\u0011%\u0011q\u0018\u0005\b\u0003\u000b\u0004A\u0011BAd\u0011\u001d\ti\r\u0001C\u0005\u0003\u001fDq!a8\u0001\t\u0013\t\t\u000fC\u0004\u0002h\u0002!I!!;\t\u000f\u00055\b\u0001\"\u0003\u0002p\"9\u00111\u001f\u0001\u0005\n\u0005U\bbBA}\u0001\u0011%\u00111 \u0002\u0015)JLwmZ3s\u0003N\u001cu\u000eZ3TKJ4\u0018nY3\u000b\u0005uq\u0012aB:feZL7-\u001a\u0006\u0003?\u0001\na!Y:d_\u0012,'BA\u0011#\u0003%AHN]3mK\u0006\u001cXM\u0003\u0002$I\u0005I\u00010\u001a2jC2\f'm\u001d\u0006\u0002K\u0005\u00191m\\7\u0004\u0001M\u0019\u0001\u0001\u000b\u0018\u0011\u0005%bS\"\u0001\u0016\u000b\u0003-\nQa]2bY\u0006L!!\f\u0016\u0003\r\u0005s\u0017PU3g!\tyC'D\u00011\u0015\t\t$'A\u0003tY\u001a$$NC\u00014\u0003!9'/\u001b>{Y\u0016$\u0017BA\u001b1\u0005\u001daunZ4j]\u001e\f\u0011\u0003\u001e:jO\u001e,'OU3q_NLGo\u001c:z!\tA4(D\u0001:\u0015\tQ\u0004%\u0001\u0006sKB|7/\u001b;pefL!\u0001P\u001d\u0003#Q\u0013\u0018nZ4feJ+\u0007o\\:ji>\u0014\u00180A\tsK2,\u0017m]3SKB|7/\u001b;pef\u0004\"\u0001O \n\u0005\u0001K$!\u0005*fY\u0016\f7/\u001a*fa>\u001c\u0018\u000e^8ss\u0006q!/\u001a7fCN,7+\u001a:wS\u000e,\u0007CA\"F\u001b\u0005!%BA\u000f!\u0013\t1EI\u0001\bSK2,\u0017m]3TKJ4\u0018nY3\u0002\u001b\u0019|G\u000eZ3s'\u0016\u0014h/[2f!\t\u0019\u0015*\u0003\u0002K\t\niai\u001c7eKJ\u001cVM\u001d<jG\u0016\fqB]3gKJ,gnY3T_24XM\u001d\t\u0003\u001b:k\u0011\u0001H\u0005\u0003\u001fr\u0011qBU3gKJ,gnY3T_24XM]\u0001\u0011iJLwmZ3s\u0019&4WmY=dY\u0016\u00042AU,Z\u001b\u0005\u0019&B\u0001+V\u0003\u0019\t7\r^8sg*\u0011a\u000bI\u0001\tiJLwmZ3sg&\u0011\u0001l\u0015\u0002\u0011)JLwmZ3s\u0019&4WmY=dY\u0016\u0004\"AW/\u000e\u0003mS!\u0001\u0018\u0011\u0002\r\u0011|W.Y5o\u0013\tq6LA\u0004Ue&<w-\u001a:\u0002\u0017\rL\u0017\nZ*feZL7-\u001a\t\u0003\u0007\u0006L!A\u0019#\u0003\u0017\rK\u0017\nZ*feZL7-Z\u0001\u000fiJLwmZ3s'\u0016\u0014h/[2f!\t)w-D\u0001g\u0015\tiR+\u0003\u0002iM\nqAK]5hO\u0016\u00148+\u001a:wS\u000e,\u0017\u0001C3wK:$()^:\u0011\u0005-tW\"\u00017\u000b\u00055\u0004\u0013AB3wK:$8/\u0003\u0002pY\n\t\u0002\f\u0014*fY\u0016\f7/Z#wK:$()^:\u0002\rqJg.\u001b;?))\u00118\u000f^;wobL(p\u001f\t\u0003\u001b\u0002AQA\u000e\u0006A\u0002]BQ!\u0010\u0006A\u0002yBQ!\u0011\u0006A\u0002\tCQa\u0012\u0006A\u0002!CQa\u0013\u0006A\u00021CQ\u0001\u0015\u0006A\u0002ECQa\u0018\u0006A\u0002\u0001DQa\u0019\u0006A\u0002\u0011DQ!\u001b\u0006A\u0002)D#AC?\u0011\u0007y\f\u0019\"D\u0001\u0000\u0015\u0011\t\t!a\u0001\u0002\u0015\u0005tgn\u001c;bi&|gN\u0003\u0003\u0002\u0006\u0005\u001d\u0011a\u00024bGR|'/\u001f\u0006\u0005\u0003\u0013\tY!A\u0003cK\u0006t7O\u0003\u0003\u0002\u000e\u0005=\u0011aD:qe&twM\u001a:b[\u0016<xN]6\u000b\u0005\u0005E\u0011aA8sO&\u0019\u0011QC@\u0003\u0013\u0005+Ho\\<je\u0016$\u0017a\u00029s_\u000e,7o\u001d\u000b\u0007\u00037\t\t#!\r\u0011\u00075\u000bi\"C\u0002\u0002 q\u0011A\"S7q_J$(+Z:vYRDq!a\t\f\u0001\u0004\t)#A\u0004d_:$X\r\u001f;\u0011\t\u0005\u001d\u0012QF\u0007\u0003\u0003SQ1!a\u000b\u001f\u0003\u0015)H/\u001b7t\u0013\u0011\ty#!\u000b\u0003\u001b%k\u0007o\u001c:u\u0007>tG/\u001a=u\u0011\u0019\t\u0019d\u0003a\u00013\u00069AO]5hO\u0016\u0014\u0018A\u00049s_\u000e,7o\u001d+sS\u001e<WM\u001d\u000b\u0007\u0003s\ty$!\u0011\u0011\u0007%\nY$C\u0002\u0002>)\u0012A!\u00168ji\"9\u00111\u0005\u0007A\u0002\u0005\u0015\u0002BBA\u001a\u0019\u0001\u0007\u0011,\u0001\u0004de\u0016\fG/\u001a\u000b\t\u00037\t9%!\u0013\u0002L!9\u00111E\u0007A\u0002\u0005\u0015\u0002BBA\u001a\u001b\u0001\u0007\u0011\fC\u0004\u0002N5\u0001\r!a\u0014\u0002\u0013Q\u0014\u0018nZ4fe&#\u0007\u0003BA)\u0003?rA!a\u0015\u0002\\A\u0019\u0011Q\u000b\u0016\u000e\u0005\u0005]#bAA-M\u00051AH]8pizJ1!!\u0018+\u0003\u0019\u0001&/\u001a3fM&!\u0011\u0011MA2\u0005\u0019\u0019FO]5oO*\u0019\u0011Q\f\u0016\u0002\rU\u0004H-\u0019;f)!\tY\"!\u001b\u0002l\u0005=\u0004bBA\u0012\u001d\u0001\u0007\u0011Q\u0005\u0005\u0007\u0003[r\u0001\u0019A-\u0002\u0011\u0015D\u0018n\u001d;j]\u001eDa!a\r\u000f\u0001\u0004I\u0016\u0001\u0003<bY&$\u0017\r^3\u0015\r\u0005U\u0014QSAL!\u0019\t9(!!\u0002\b:!\u0011\u0011PA?\u001d\u0011\t)&a\u001f\n\u0003-J1!a +\u0003\u001d\u0001\u0018mY6bO\u0016LA!a!\u0002\u0006\n!A*[:u\u0015\r\tyH\u000b\t\u0005\u0003\u0013\u000b\t*\u0004\u0002\u0002\f*\u0019q$!$\u000b\u0007\u0005=\u0005%\u0001\u0006wKJ\u001c\u0018n\u001c8j]\u001eLA!a%\u0002\f\n\tb+\u00197jI\u0006$\u0018n\u001c8NKN\u001c\u0018mZ3\t\u000f\u0005\rr\u00021\u0001\u0002&!1\u00111G\bA\u0002e\u000baC^1mS\u0012\fG/Z*u_J,G\r\u0016:jO\u001e,'o\u001d\u000b\u0005\u0003s\ti\nC\u0004\u0002 B\u0001\r!!)\u0002\u001dM$xN]3e)JLwmZ3sgB)\u0011qOAA3\u0006aa-\u001b8e)\u0016l\u0007\u000f\\1uKR1\u0011qUAW\u0003c\u00032AWAU\u0013\r\tYk\u0017\u0002\b%\u0016dW-Y:f\u0011\u001d\ty+\u0005a\u0001\u0003\u001f\n\u0011\"\u001b3PeRKG\u000f\\3\t\u000f\u0005M\u0016\u00031\u0001\u0002P\u0005a\u0001/\u0019:f]R4u\u000e\u001c3fe\u0006\u0001b-\u001b8e)\u0016l\u0007\u000f\\1uK\nK\u0018\n\u001a\u000b\u0007\u0003O\u000bI,a/\t\u000f\u0005=&\u00031\u0001\u0002P!9\u00111\u0017\nA\u0002\u0005=\u0013a\u00054j]\u0012$V-\u001c9mCR,')\u001f+ji2,GCBAT\u0003\u0003\f\u0019\rC\u0004\u00020N\u0001\r!a\u0014\t\u000f\u0005M6\u00031\u0001\u0002P\u00051\"/Z:pYZ,'+\u001a7fCN,gi\u001c7eKJLE\r\u0006\u0003\u0002P\u0005%\u0007bBAf)\u0001\u0007\u0011qJ\u0001\u0010e\u0016dW-Y:f\r>dG-\u001a:JI\u0006AR\u000f\u001d3bi\u0016$&/[4hKJ\u001c\bK]8qKJ$\u0018.Z:\u0015\u0011\u0005e\u0012\u0011[Aj\u0003+Da!a\r\u0016\u0001\u0004I\u0006bBAZ+\u0001\u0007\u0011q\n\u0005\b\u0003/,\u0002\u0019AAm\u0003\u0011Aw.\\3\u0011\u000b%\nY.a\u0014\n\u0007\u0005u'F\u0001\u0004PaRLwN\\\u0001\u000bO\u0016tWM]1uK&#G\u0003BA(\u0003GDq!!:\u0017\u0001\u0004\ty%\u0001\u0005qCJ,g\u000e^%e\u0003A1\u0018\r\\5eCR,gi\u001c7eKJLE\r\u0006\u0003\u0002:\u0005-\bBBA\u001a/\u0001\u0007\u0011,A\bva\u0012\fG/\u001a,be&\f'\r\\3t)\u0011\tI$!=\t\r\u0005M\u0002\u00041\u0001Z\u00035)g.\u00192mKR\u0013\u0018nZ4feR!\u0011\u0011HA|\u0011\u0019\t\u0019$\u0007a\u00013\u000612m\u001c9z\u0013:$XM\u001d8bYB\u0013x\u000e]3si&,7\u000f\u0006\u0004\u0002:\u0005u\u0018q \u0005\u0007\u0003[R\u0002\u0019A-\t\r\t\u0005!\u00041\u0001Z\u00039)\b\u000fZ1uK\u0012$&/[4hKJD3\u0001\u0001B\u0003!\u0011\u00119A!\u0004\u000e\u0005\t%!\u0002\u0002B\u0006\u0003\u0017\t!b\u001d;fe\u0016|G/\u001f9f\u0013\u0011\u0011yA!\u0003\u0003\u000fM+'O^5dK\u0002")
public class TriggerAsCodeService
implements Logging {
    private final TriggerRepository triggerRepository;
    private final ReleaseRepository releaseRepository;
    private final ReleaseService releaseService;
    private final FolderService folderService;
    private final ReferenceSolver referenceSolver;
    private final TriggerLifecycle<Trigger> triggerLifecycle;
    private final CiIdService ciIdService;
    private final TriggerService triggerService;
    private final XLReleaseEventBus eventBus;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        TriggerAsCodeService triggerAsCodeService = this;
        synchronized (triggerAsCodeService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public ImportResult process(ImportContext context, Trigger trigger) {
        this.logger().debug((Function0 & Serializable)() -> "Processing trigger: " + trigger.toString() + " with metadata " + context.metadata().toString());
        String parentFolder = (String)context.scope().getFolderId().getOrElse((Function0 & Serializable)() -> "/");
        List storedTriggers = CollectionConverters$.MODULE$.ListHasAsScala(this.triggerRepository.findByFolderId(parentFolder, false, (Pageable)PageRequest.of((int)0, (int)Integer.MAX_VALUE)).getContent()).asScala().toList();
        this.validateStoredTriggers((List<Trigger>)storedTriggers);
        this.processTrigger(context, trigger);
        Option option = storedTriggers.find((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)TriggerAsCodeService.$anonfun$process$3(trigger, x$1)));
        if (option instanceof Some) {
            Some some = (Some)option;
            Trigger existing = (Trigger)some.value();
            this.logger().debug((Function0 & Serializable)() -> "Updating trigger: " + existing.toString());
            return this.update(context, existing, trigger);
        }
        if (None$.MODULE$.equals(option)) {
            this.logger().debug((Function0 & Serializable)() -> "Creating trigger: " + trigger.toString());
            return this.create(context, trigger, this.generateId(parentFolder));
        }
        throw new MatchError((Object)option);
    }

    private void processTrigger(ImportContext context, Trigger trigger) {
        String parentFolder = (String)context.scope().getFolderId().getOrElse((Function0 & Serializable)() -> "/");
        Option home = context.metadata().get((Object)MetadataFields$.MODULE$.HOMEFOLDER().toString());
        this.referenceSolver.resolveReferences((ConfigurationItem)trigger, context.references(), parentFolder);
        this.updateTriggersProperties(trigger, parentFolder, (Option<String>)home);
        this.validateFolderId(trigger);
        this.updateVariables(trigger);
        CiHelper.fixUpInternalReferences((ConfigurationItem)trigger);
    }

    private ImportResult create(ImportContext context, Trigger trigger, String triggerId) {
        trigger.setId(triggerId);
        Trigger created = this.triggerRepository.create(trigger);
        List<ValidationMessage> messages = this.validate(context, trigger);
        return new ImportResult((List<AsCodeResponse.ChangedIds>)new .colon.colon((Object)AsCodeResponse.EntityKinds$.MODULE$.ExtendedString(AsCodeResponse.EntityKinds$.MODULE$.CI()).ids().withCreated(created.getId()), (List)Nil$.MODULE$), (scala.collection.immutable.Seq<PostCommitAction>)new .colon.colon(() -> this.enableTrigger(created), (List)new .colon.colon(() -> $this.eventBus.publish((XLReleaseEvent)new TriggerCreatedFromAsCodeEvent(created, context.scmData())), (List)Nil$.MODULE$)), (Map<String, Map<Type, AsCodeResponse.ChangedIds>>)Predef$.MODULE$.Map().empty(), messages);
    }

    private ImportResult update(ImportContext context, Trigger existing, Trigger trigger) {
        trigger.setId(existing.getId());
        trigger.setCiUid(existing.getCiUid());
        this.copyInternalProperties(existing, trigger);
        List<ValidationMessage> messages = this.validate(context, trigger);
        Trigger updated = this.triggerRepository.update(trigger);
        return new ImportResult((List<AsCodeResponse.ChangedIds>)new .colon.colon((Object)AsCodeResponse.EntityKinds$.MODULE$.ExtendedString(AsCodeResponse.EntityKinds$.MODULE$.CI()).ids().withUpdated(updated.getId()), (List)Nil$.MODULE$), (scala.collection.immutable.Seq<PostCommitAction>)new .colon.colon(() -> $this.triggerService.refreshTrigger(updated), (List)new .colon.colon(() -> this.enableTrigger(updated), (List)new .colon.colon(() -> $this.eventBus.publish((XLReleaseEvent)new TriggerUpdatedFromAsCodeEvent(updated, context.scmData())), (List)Nil$.MODULE$))), (Map<String, Map<Type, AsCodeResponse.ChangedIds>>)Predef$.MODULE$.Map().empty(), messages);
    }

    private List<ValidationMessage> validate(ImportContext context, Trigger trigger) {
        Option<ImportValidator> option = context.validator();
        if (option instanceof Some) {
            Some some = (Some)option;
            ImportValidator validator = (ImportValidator)some.value();
            return validator.validateCi((ConfigurationItem)trigger, context.getFolderInfo()).toList();
        }
        if (None$.MODULE$.equals(option)) {
            return package$.MODULE$.List().empty();
        }
        throw new MatchError(option);
    }

    private void validateStoredTriggers(List<Trigger> storedTriggers) {
        ((IterableOnceOps)storedTriggers.groupBy((Function1 & Serializable)x$2 -> x$2.getTitle()).values().filter((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)TriggerAsCodeService.$anonfun$validateStoredTriggers$2(x$3)))).foreach((Function1 & Serializable)triggerGroup -> {
            Trigger trigger = (Trigger)triggerGroup.head();
            throw new AsCodeException("More than one trigger with the name [" + trigger.getTitle() + "] is present in the repository. Don't know which one to update", AsCodeException$.MODULE$.$lessinit$greater$default$2());
        });
    }

    public Release com$xebialabs$xlrelease$ascode$service$TriggerAsCodeService$$findTemplate(String idOrTitle, String parentFolder) {
        if (Ids.isReleaseId((String)idOrTitle)) {
            return this.findTemplateById(idOrTitle, parentFolder);
        }
        return this.findTemplateByTitle(idOrTitle, parentFolder);
    }

    private Release findTemplateById(String idOrTitle, String parentFolder) {
        Release release;
        try {
            release = this.releaseService.findById(idOrTitle);
        }
        catch (LogFriendlyNotFoundException nfe) {
            release = this.findTemplateByTitle(idOrTitle, parentFolder);
        }
        catch (Exception e) {
            throw new AsCodeException("Failed to find template [" + idOrTitle + "], error [" + e.getMessage() + "].", AsCodeException$.MODULE$.$lessinit$greater$default$2());
        }
        return release;
    }

    private Release findTemplateByTitle(String idOrTitle, String parentFolder) {
        boolean bl = false;
        .colon.colon colon2 = null;
        List list = CollectionConverters$.MODULE$.ListHasAsScala(this.releaseService.findTemplatesByTitle(parentFolder, idOrTitle, 0, 2, 1)).asScala().toList();
        if (list instanceof .colon.colon) {
            bl = true;
            colon2 = (.colon.colon)list;
            Release template = (Release)colon2.head();
            List list2 = colon2.next$access$1();
            if (Nil$.MODULE$.equals(list2)) {
                return template;
            }
        }
        if (bl) {
            throw new AsCodeException("More than one template with name [" + idOrTitle + "] is present in the folder [" + parentFolder + "]. Please use an unique name.", AsCodeException$.MODULE$.$lessinit$greater$default$2());
        }
        if (Nil$.MODULE$.equals(list)) {
            throw new AsCodeException("There is no template with name [" + idOrTitle + "] under folder [" + parentFolder + "]", AsCodeException$.MODULE$.$lessinit$greater$default$2());
        }
        throw new MatchError((Object)list);
    }

    public String com$xebialabs$xlrelease$ascode$service$TriggerAsCodeService$$resolveReleaseFolderId(String releaseFolderId) {
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> $this.folderService.findByPath(StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(releaseFolderId), "/"), $this.folderService.findByPath$default$2()).getId());
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            String resolvedReleaseFolderID = (String)success.value();
            return resolvedReleaseFolderID;
        }
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable ex = failure.exception();
            throw new AsCodeException("Unable to resolve release folder id, " + releaseFolderId + " for trigger: failure message " + ex.getMessage(), AsCodeException$.MODULE$.$lessinit$greater$default$2());
        }
        throw new MatchError((Object)try_);
    }

    private void updateTriggersProperties(Trigger trigger, String parentFolder, Option<String> home) {
        trigger.setFolderId(parentFolder);
        Trigger trigger2 = trigger;
        if (trigger2 instanceof ReleaseTrigger) {
            ReleaseTrigger releaseTrigger = (ReleaseTrigger)trigger2;
            releaseTrigger.setTemplate(this.com$xebialabs$xlrelease$ascode$service$TriggerAsCodeService$$findTemplate(releaseTrigger.getTemplate(), parentFolder).getId());
            releaseTrigger.setReleaseFolder((String)Option$.MODULE$.apply((Object)FolderAsCodeService$.MODULE$.absolutePath(releaseTrigger.getReleaseFolder(), home)).map((Function1 & Serializable)releaseFolderId -> this.com$xebialabs$xlrelease$ascode$service$TriggerAsCodeService$$resolveReleaseFolderId((String)releaseFolderId)).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()));
            return;
        }
        if (trigger2 instanceof EventBasedTrigger) {
            EventBasedTrigger eventBasedTrigger = (EventBasedTrigger)trigger2;
            CollectionConverters$.MODULE$.ListHasAsScala(eventBasedTrigger.mappedProperties()).asScala().find((Function1 & Serializable)p -> BoxesRunTime.boxToBoolean((boolean)TriggerAsCodeService.$anonfun$updateTriggersProperties$2(p))).collect((PartialFunction)new Serializable(this, parentFolder){
                private static final long serialVersionUID = 0L;
                private final /* synthetic */ TriggerAsCodeService $outer;
                private final String parentFolder$1;

                public final <A1 extends MappedProperty, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    A1 A1 = x1;
                    if (A1 instanceof MappedProperty.StringValue) {
                        MappedProperty.StringValue stringValue = (MappedProperty.StringValue)A1;
                        return (B1)this.$outer.com$xebialabs$xlrelease$ascode$service$TriggerAsCodeService$$findTemplate(stringValue.value(), this.parentFolder$1);
                    }
                    return (B1)function1.apply(x1);
                }

                public final boolean isDefinedAt(MappedProperty x1) {
                    MappedProperty mappedProperty = x1;
                    return mappedProperty instanceof MappedProperty.StringValue;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.parentFolder$1 = parentFolder$1;
                }
            }).map((Function1 & Serializable)templateId -> BoxesRunTime.boxToBoolean((boolean)TriggerAsCodeService.$anonfun$updateTriggersProperties$4(eventBasedTrigger, templateId)));
            eventBasedTrigger.mappedProperties().removeIf(p -> {
                String string = p.targetProperty();
                String string2 = "template";
                return !(string != null ? !string.equals(string2) : string2 != null);
            });
            CollectionConverters$.MODULE$.ListHasAsScala(eventBasedTrigger.mappedProperties()).asScala().find((Function1 & Serializable)p -> BoxesRunTime.boxToBoolean((boolean)TriggerAsCodeService.$anonfun$updateTriggersProperties$6(p))).collect((PartialFunction)new Serializable(this, home){
                private static final long serialVersionUID = 0L;
                private final /* synthetic */ TriggerAsCodeService $outer;
                private final Option home$1;

                public final <A1 extends MappedProperty, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                    A1 A1 = x2;
                    if (A1 instanceof MappedProperty.StringValue) {
                        MappedProperty.StringValue stringValue = (MappedProperty.StringValue)A1;
                        return (B1)this.$outer.com$xebialabs$xlrelease$ascode$service$TriggerAsCodeService$$resolveReleaseFolderId(FolderAsCodeService$.MODULE$.absolutePath(stringValue.value(), (Option<String>)this.home$1));
                    }
                    return (B1)function1.apply(x2);
                }

                public final boolean isDefinedAt(MappedProperty x2) {
                    MappedProperty mappedProperty = x2;
                    return mappedProperty instanceof MappedProperty.StringValue;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.home$1 = home$1;
                }
            }).map((Function1 & Serializable)folderId -> BoxesRunTime.boxToBoolean((boolean)TriggerAsCodeService.$anonfun$updateTriggersProperties$8(eventBasedTrigger, folderId)));
            eventBasedTrigger.mappedProperties().removeIf(p -> {
                String string = p.targetProperty();
                String string2 = "releaseFolder";
                return !(string != null ? !string.equals(string2) : string2 != null);
            });
            return;
        }
        if (trigger2 instanceof StatusWebhookTrigger) {
            StatusWebhookTrigger statusWebhookTrigger = (StatusWebhookTrigger)trigger2;
            CollectionConverters$.MODULE$.ListHasAsScala(statusWebhookTrigger.mappedProperties()).asScala().find((Function1 & Serializable)p -> BoxesRunTime.boxToBoolean((boolean)TriggerAsCodeService.$anonfun$updateTriggersProperties$10(p))).collect((PartialFunction)new Serializable(this, parentFolder){
                private static final long serialVersionUID = 0L;
                private final /* synthetic */ TriggerAsCodeService $outer;
                private final String parentFolder$1;

                public final <A1 extends MappedProperty, B1> B1 applyOrElse(A1 x3, Function1<A1, B1> function1) {
                    A1 A1 = x3;
                    if (A1 instanceof MappedProperty.StringValue) {
                        MappedProperty.StringValue stringValue = (MappedProperty.StringValue)A1;
                        return (B1)this.$outer.com$xebialabs$xlrelease$ascode$service$TriggerAsCodeService$$findTemplate(stringValue.value(), this.parentFolder$1);
                    }
                    return (B1)function1.apply(x3);
                }

                public final boolean isDefinedAt(MappedProperty x3) {
                    MappedProperty mappedProperty = x3;
                    return mappedProperty instanceof MappedProperty.StringValue;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.parentFolder$1 = parentFolder$1;
                }
            }).map((Function1 & Serializable)templateId -> BoxesRunTime.boxToBoolean((boolean)TriggerAsCodeService.$anonfun$updateTriggersProperties$12(statusWebhookTrigger, templateId)));
            statusWebhookTrigger.mappedProperties().removeIf(p -> {
                String string = p.targetProperty();
                String string2 = "template";
                return !(string != null ? !string.equals(string2) : string2 != null);
            });
            CollectionConverters$.MODULE$.ListHasAsScala(statusWebhookTrigger.mappedProperties()).asScala().find((Function1 & Serializable)p -> BoxesRunTime.boxToBoolean((boolean)TriggerAsCodeService.$anonfun$updateTriggersProperties$14(p))).collect((PartialFunction)new Serializable(this, home){
                private static final long serialVersionUID = 0L;
                private final /* synthetic */ TriggerAsCodeService $outer;
                private final Option home$1;

                public final <A1 extends MappedProperty, B1> B1 applyOrElse(A1 x4, Function1<A1, B1> function1) {
                    A1 A1 = x4;
                    if (A1 instanceof MappedProperty.StringValue) {
                        MappedProperty.StringValue stringValue = (MappedProperty.StringValue)A1;
                        return (B1)this.$outer.com$xebialabs$xlrelease$ascode$service$TriggerAsCodeService$$resolveReleaseFolderId(FolderAsCodeService$.MODULE$.absolutePath(stringValue.value(), (Option<String>)this.home$1));
                    }
                    return (B1)function1.apply(x4);
                }

                public final boolean isDefinedAt(MappedProperty x4) {
                    MappedProperty mappedProperty = x4;
                    return mappedProperty instanceof MappedProperty.StringValue;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.home$1 = home$1;
                }
            }).map((Function1 & Serializable)folderId -> BoxesRunTime.boxToBoolean((boolean)TriggerAsCodeService.$anonfun$updateTriggersProperties$16(statusWebhookTrigger, folderId)));
            statusWebhookTrigger.mappedProperties().removeIf(p -> {
                String string = p.targetProperty();
                String string2 = "releaseFolder";
                return !(string != null ? !string.equals(string2) : string2 != null);
            });
            return;
        }
        throw Predef$.MODULE$.$qmark$qmark$qmark();
    }

    private String generateId(String parentId) {
        return this.ciIdService.getUniqueId(Type.valueOf(Trigger.class), parentId);
    }

    private void validateFolderId(Trigger trigger) {
        if (new FolderId(trigger.getFolderId()).absolute().equals(Ids.ROOT_FOLDER_ID)) {
            throw new AsCodeException("Failed to create trigger " + trigger.getTitle() + ", you cannot create trigger on the root folder. The root folder path is not supported.", AsCodeException$.MODULE$.$lessinit$greater$default$2());
        }
    }

    private void updateVariables(Trigger trigger) {
        Trigger trigger2 = trigger;
        if (trigger2 instanceof ReleaseTrigger) {
            ReleaseTrigger releaseTrigger = (ReleaseTrigger)trigger2;
            java.util.List variables = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(this.releaseRepository.findById(releaseTrigger.getTemplate(), ResolveOptions$.MODULE$.WITH_DECORATORS()).getVariables()).asScala().filter((Function1 & Serializable)v -> BoxesRunTime.boxToBoolean((boolean)TriggerAsCodeService.$anonfun$updateVariables$1(releaseTrigger, v)))).toList()).asJava();
            Release variableHolderTemplate = ReleaseBuilder.newRelease().withId(releaseTrigger.getTemplate()).withVariables(variables).build();
            variableHolderTemplate.setVariableValues(CollectionConverters$.MODULE$.MutableMapHasAsJava((scala.collection.mutable.Map)CollectionConverters$.MODULE$.MapHasAsScala(releaseTrigger.getTemplateVariableValues(x$4 -> !x$4.isPassword())).asScala().filter((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)TriggerAsCodeService.$anonfun$updateVariables$3(x$5)))).asJava());
            variableHolderTemplate.setPasswordVariableValues(releaseTrigger.getTemplatePasswordVariables());
            releaseTrigger.setVariables(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(variableHolderTemplate.getVariables()).asScala().filter((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)TriggerAsCodeService.$anonfun$updateVariables$4(x$6)))).toList()).asJava());
            return;
        }
    }

    private void enableTrigger(Trigger trigger) {
        if (trigger.isEnabled()) {
            this.triggerLifecycle.enable(trigger, false);
            return;
        }
        this.triggerLifecycle.disable(trigger);
    }

    private void copyInternalProperties(Trigger existing, Trigger updatedTrigger) {
        CollectionConverters$.MODULE$.ListHasAsScala(updatedTrigger.getInternalProperties()).asScala().foreach((Function1 & Serializable)internalProperty -> {
            updatedTrigger.setProperty(internalProperty, existing.getProperty(internalProperty));
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$process$3(Trigger trigger$1, Trigger x$1) {
        String string = x$1.getTitle();
        String string2 = trigger$1.getTitle();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$validateStoredTriggers$2(List x$3) {
        return x$3.length() > 1;
    }

    public static final /* synthetic */ boolean $anonfun$updateTriggersProperties$2(MappedProperty p) {
        String string = p.targetProperty();
        String string2 = "template";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$updateTriggersProperties$4(EventBasedTrigger x3$1, Release templateId) {
        MappedProperty.StringValue value = new MappedProperty.StringValue("templateId");
        value.setValue(templateId.getId());
        return x3$1.mappedProperties().add(value);
    }

    public static final /* synthetic */ boolean $anonfun$updateTriggersProperties$6(MappedProperty p) {
        String string = p.targetProperty();
        String string2 = "releaseFolder";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$updateTriggersProperties$8(EventBasedTrigger x3$1, String folderId) {
        MappedProperty.StringValue value = new MappedProperty.StringValue("releaseFolderId");
        value.setValue(folderId);
        return x3$1.mappedProperties().add(value);
    }

    public static final /* synthetic */ boolean $anonfun$updateTriggersProperties$10(MappedProperty p) {
        String string = p.targetProperty();
        String string2 = "template";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$updateTriggersProperties$12(StatusWebhookTrigger x4$1, Release templateId) {
        MappedProperty.StringValue value = new MappedProperty.StringValue("templateId");
        value.setValue(templateId.getId());
        return x4$1.mappedProperties().add(value);
    }

    public static final /* synthetic */ boolean $anonfun$updateTriggersProperties$14(MappedProperty p) {
        String string = p.targetProperty();
        String string2 = "releaseFolder";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$updateTriggersProperties$16(StatusWebhookTrigger x4$1, String folderId) {
        MappedProperty.StringValue value = new MappedProperty.StringValue("releaseFolderId");
        value.setValue(folderId);
        return x4$1.mappedProperties().add(value);
    }

    public static final /* synthetic */ boolean $anonfun$updateVariables$1(ReleaseTrigger x2$1, Variable v) {
        return x2$1.getVariablesByKeys().containsKey(v.getKey());
    }

    public static final /* synthetic */ boolean $anonfun$updateVariables$3(Tuple2 x$5) {
        return x$5._2() != null;
    }

    public static final /* synthetic */ boolean $anonfun$updateVariables$4(Variable x$6) {
        return x$6.getId() != null;
    }

    @Autowired
    public TriggerAsCodeService(TriggerRepository triggerRepository, ReleaseRepository releaseRepository, ReleaseService releaseService, FolderService folderService, ReferenceSolver referenceSolver, TriggerLifecycle<Trigger> triggerLifecycle, CiIdService ciIdService, TriggerService triggerService, XLReleaseEventBus eventBus) {
        this.triggerRepository = triggerRepository;
        this.releaseRepository = releaseRepository;
        this.releaseService = releaseService;
        this.folderService = folderService;
        this.referenceSolver = referenceSolver;
        this.triggerLifecycle = triggerLifecycle;
        this.ciIdService = ciIdService;
        this.triggerService = triggerService;
        this.eventBus = eventBus;
        Logging.$init$((Logging)this);
    }
}

