package com.xebialabs.xlrelease.ascode.service.generatestrategy

import com.xebialabs.xlrelease.api.v1.filter.EnvironmentStageFilters
import com.xebialabs.xlrelease.ascode.utils.Utils
import com.xebialabs.xlrelease.domain.environments.EnvironmentStage
import com.xebialabs.xlrelease.domain.folder.Folder
import com.xebialabs.xlrelease.environments.service.EnvironmentStageService
import com.xebialabs.xlrelease.security.PermissionChecker
import com.xebialabs.xlrelease.security.XLReleasePermissions.EDIT_ENVIRONMENT
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Component

import scala.jdk.CollectionConverters._

@Component
class EnvironmentStageAsCodeGenerator @Autowired()(environmentStageService: EnvironmentStageService,
                                                   permissions: PermissionChecker) extends ApplicationEnvironmentGenerateStrategy[EnvironmentStage] {
  override val generateOrder: Double = 250

  override def isDefinedAt(config: CiGenerateConfig): Boolean = {
    config.generateConfig.generateEnvironments
  }

  override protected def generateGlobal(config: CiGenerateConfig): Map[Option[Folder], List[EnvironmentStage]] = {
    if (config.isAdminUser || permissions.hasGlobalPermission(EDIT_ENVIRONMENT)) {
      val stages = environmentStageService.searchStages(new EnvironmentStageFilters).asScala.toList
        .filter { ci =>
          config.ciTitle.forall { n => Utils.stringLike(ci.getTitle, n) }
        }
      Map(None -> stages)
    } else {
      Map.empty
    }
  }

}
