package com.xebialabs.xlrelease.ascode.service.referencehandler.stringhandler

import com.xebialabs.ascode.exception.AsCodeException
import com.xebialabs.xlrelease.domain.environments.Environment
import com.xebialabs.xlrelease.environments.service.EnvironmentService
import com.xebialabs.xlrelease.repository.Ids
import com.xebialabs.xlrelease.udm.reporting.filters.EnvironmentFilter
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Component

import scala.util.{Failure, Success, Try}

@Component
@Autowired
class EnvironmentFilterStringReferenceCreationHandler(environmentService: EnvironmentService) extends StringReferenceCreationHandler {
  override def isDefinedAt(config: StringReferenceCreationConfig): Boolean = config.ci.isInstanceOf[EnvironmentFilter]

  override def apply(config: StringReferenceCreationConfig): StringReferenceContainer = {
    val filter = config.ci.asInstanceOf[EnvironmentFilter]
    val envName = filter.getEnvironmentId
    val descriptor = filter.getType.getDescriptor.getPropertyDescriptor("environmentId")

    val environment: Environment = Try(environmentService.findEnvironmentByTitle(envName)) match {
      case Success(env) => env
      case Failure(_) => throw new AsCodeException(s"Environment with name $envName was not found. Please create it first before using it.")
    }
    config.ci.setId("-1")
    StringReferenceContainer(config.ci, Map(descriptor -> Some(Ids.getName(environment.getId))))
  }
}
