package com.xebialabs.xlrelease.ascode.service

import com.xebialabs.ascode.yaml.dto.AsCodeResponse.EntityKinds.{CI, _}
import com.xebialabs.deployit.exception.NotFoundException
import com.xebialabs.xlrelease.api.v1.EnvironmentLabelApi
import com.xebialabs.xlrelease.ascode.utils.ImportContext
import com.xebialabs.xlrelease.domain.environments.EnvironmentLabel
import com.xebialabs.xlrelease.environments.repository.EnvironmentLabelRepository
import com.xebialabs.xlrelease.versioning.ascode.ValidationMessage
import org.springframework.stereotype.Service

@Service
class EnvironmentLabelAsCodeService(environmentLabelApi: EnvironmentLabelApi,
                                    environmentLabelRepository: EnvironmentLabelRepository) {

  def process(context: ImportContext, environmentLabel: EnvironmentLabel): ImportResult = {
    try {
      val existing = environmentLabelRepository.findByTitle(environmentLabel.getTitle)
      update(context, environmentLabel, existing)
    } catch {
      case _: NotFoundException =>
        create(context, environmentLabel)
    }
  }

  private def create(context: ImportContext, environmentLabel: EnvironmentLabel) = {
    val messages = validate(context, environmentLabel)
    val created = environmentLabelApi.create(environmentLabel)
    ImportResult(List(CI.ids.withCreated(created.getId)),
      Seq.empty,
      Map.empty,
      messages
    )
  }

  private def update(context: ImportContext, environmentLabel: EnvironmentLabel, existing: EnvironmentLabel) = {
    environmentLabel.setId(existing.getId)
    val messages = validate(context, environmentLabel)
    val updated = environmentLabelApi.update(environmentLabel)
    ImportResult(List(CI.ids.withUpdated(updated.getId)),
      Seq.empty,
      Map.empty,
      messages
    )
  }

  private def validate(context: ImportContext, environmentLabel: EnvironmentLabel): List[ValidationMessage] = {
    context.validator match {
      case Some(validator) => validator.validateCi(environmentLabel, context.getFolderInfo()).toList
      case None => List.empty
    }
  }

}
