package com.xebialabs.xlrelease.ascode.service.spec

import com.xebialabs.ascode.service.spec.{InterpreterContext, SpecInterpreter}
import com.xebialabs.ascode.yaml.dto.AsCodeResponse
import com.xebialabs.ascode.yaml.dto.AsCodeResponse.EntityKinds._
import com.xebialabs.ascode.yaml.model.RolesSpec
import com.xebialabs.xlrelease.ascode.service.RolesAsCodeService
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Component

@Component
@Autowired
class RolesSpecInterpreter(rolesAsCodeService: RolesAsCodeService) extends SpecInterpreter {
  override def isDefinedAt(context: InterpreterContext): Boolean = context.definition.spec.isInstanceOf[RolesSpec]

  override def apply(context: InterpreterContext): AsCodeResponse = {
    val rolesSpec = context.definition.spec.asInstanceOf[RolesSpec]
    AsCodeResponse.ids(rolesSpec.roles.foldLeft(ROLE.ids) { (acc, role) =>
      acc.merge(rolesAsCodeService.handleRole(role))
    })
  }
}
